/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.chrono;

import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DurationField;
import com.jn.langx.util.jodatime.DurationFieldType;
import com.jn.langx.util.jodatime.IllegalFieldValueException;
import com.jn.langx.util.jodatime.field.BaseDateTimeField;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.field.UnsupportedDurationField;
import java.util.Locale;

final class BasicSingleEraDateTimeField
extends BaseDateTimeField {
    private static final int ERA_VALUE = 1;
    private final String iEraText;

    BasicSingleEraDateTimeField(String text) {
        super(DateTimeFieldType.era());
        this.iEraText = text;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long instant) {
        return 1;
    }

    @Override
    public long set(long instant, int era) {
        FieldUtils.verifyValueBounds(this, era, 1, 1);
        return instant;
    }

    @Override
    public long set(long instant, String text, Locale locale) {
        if (!this.iEraText.equals(text) && !"1".equals(text)) {
            throw new IllegalFieldValueException(DateTimeFieldType.era(), text);
        }
        return instant;
    }

    @Override
    public long roundFloor(long instant) {
        return Long.MIN_VALUE;
    }

    @Override
    public long roundCeiling(long instant) {
        return Long.MAX_VALUE;
    }

    @Override
    public long roundHalfFloor(long instant) {
        return Long.MIN_VALUE;
    }

    @Override
    public long roundHalfCeiling(long instant) {
        return Long.MIN_VALUE;
    }

    @Override
    public long roundHalfEven(long instant) {
        return Long.MIN_VALUE;
    }

    @Override
    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return 1;
    }

    @Override
    public String getAsText(int fieldValue, Locale locale) {
        return this.iEraText;
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        return this.iEraText.length();
    }
}

