/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.chrono;

import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DurationField;
import com.jn.langx.util.jodatime.chrono.BasicChronology;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.field.ImpreciseDateTimeField;

class BasicYearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = -98628754872287L;
    protected final BasicChronology iChronology;

    BasicYearDateTimeField(BasicChronology chronology) {
        super(DateTimeFieldType.year(), chronology.getAverageMillisPerYear());
        this.iChronology = chronology;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long instant) {
        return this.iChronology.getYear(instant);
    }

    @Override
    public long add(long instant, int years) {
        if (years == 0) {
            return instant;
        }
        int thisYear = this.get(instant);
        int newYear = FieldUtils.safeAdd(thisYear, years);
        return this.set(instant, newYear);
    }

    @Override
    public long add(long instant, long years) {
        return this.add(instant, FieldUtils.safeToInt(years));
    }

    @Override
    public long addWrapField(long instant, int years) {
        if (years == 0) {
            return instant;
        }
        int thisYear = this.iChronology.getYear(instant);
        int wrappedYear = FieldUtils.getWrappedValue(thisYear, years, this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        return this.set(instant, wrappedYear);
    }

    @Override
    public long set(long instant, int year) {
        FieldUtils.verifyValueBounds(this, year, this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        return this.iChronology.setYear(instant, year);
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        if (minuendInstant < subtrahendInstant) {
            return -this.iChronology.getYearDifference(subtrahendInstant, minuendInstant);
        }
        return this.iChronology.getYearDifference(minuendInstant, subtrahendInstant);
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public boolean isLeap(long instant) {
        return this.iChronology.isLeapYear(this.get(instant));
    }

    @Override
    public int getLeapAmount(long instant) {
        if (this.iChronology.isLeapYear(this.get(instant))) {
            return 1;
        }
        return 0;
    }

    @Override
    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    @Override
    public int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    @Override
    public int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    @Override
    public long roundFloor(long instant) {
        return this.iChronology.getYearMillis(this.get(instant));
    }

    @Override
    public long roundCeiling(long instant) {
        int year = this.get(instant);
        long yearStartMillis = this.iChronology.getYearMillis(year);
        if (instant != yearStartMillis) {
            instant = this.iChronology.getYearMillis(year + 1);
        }
        return instant;
    }

    @Override
    public long remainder(long instant) {
        return instant - this.roundFloor(instant);
    }

    private Object readResolve() {
        return this.iChronology.year();
    }
}

