/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.chrono;

import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DurationField;
import com.jn.langx.util.jodatime.chrono.BasicChronology;
import com.jn.langx.util.jodatime.chrono.GJLocaleSymbols;
import com.jn.langx.util.jodatime.field.PreciseDurationDateTimeField;
import java.util.Locale;

final class GJDayOfWeekDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -3857947176719041436L;
    private final BasicChronology iChronology;

    GJDayOfWeekDateTimeField(BasicChronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfWeek(), days);
        this.iChronology = chronology;
    }

    @Override
    public int get(long instant) {
        return this.iChronology.getDayOfWeek(instant);
    }

    @Override
    public String getAsText(int fieldValue, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).dayOfWeekValueToText(fieldValue);
    }

    @Override
    public String getAsShortText(int fieldValue, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).dayOfWeekValueToShortText(fieldValue);
    }

    @Override
    protected int convertText(String text, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).dayOfWeekTextToValue(text);
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.weeks();
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return 7;
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getDayOfWeekMaxTextLength();
    }

    @Override
    public int getMaximumShortTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getDayOfWeekMaxShortTextLength();
    }

    private Object readResolve() {
        return this.iChronology.dayOfWeek();
    }
}

