/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.chrono;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DateTimeZone;
import com.jn.langx.util.jodatime.chrono.AssembledChronology;
import com.jn.langx.util.jodatime.chrono.GregorianChronology;
import com.jn.langx.util.jodatime.chrono.ISOYearOfEraDateTimeField;
import com.jn.langx.util.jodatime.chrono.ZonedChronology;
import com.jn.langx.util.jodatime.field.DividedDateTimeField;
import com.jn.langx.util.jodatime.field.RemainderDateTimeField;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class ISOChronology
extends AssembledChronology {
    private static final long serialVersionUID = -6212696554273812441L;
    private static final ISOChronology INSTANCE_UTC;
    private static final int FAST_CACHE_SIZE = 64;
    private static final ISOChronology[] cFastCache;
    private static final Map<DateTimeZone, ISOChronology> cCache;

    public static ISOChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static ISOChronology getInstance() {
        return ISOChronology.getInstance(DateTimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISOChronology getInstance(DateTimeZone zone) {
        int index;
        ISOChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if ((chrono = cFastCache[index = System.identityHashCode(zone) & 0x3F]) != null && chrono.getZone() == zone) {
            return chrono;
        }
        Map<DateTimeZone, ISOChronology> map = cCache;
        synchronized (map) {
            chrono = cCache.get(zone);
            if (chrono == null) {
                chrono = new ISOChronology(ZonedChronology.getInstance(INSTANCE_UTC, zone));
                cCache.put(zone, chrono);
            }
        }
        ISOChronology.cFastCache[index] = chrono;
        return chrono;
    }

    private ISOChronology(Chronology base) {
        super(base, null);
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return ISOChronology.getInstance(zone);
    }

    @Override
    public String toString() {
        String str = "ISOChronology";
        DateTimeZone zone = this.getZone();
        if (zone != null) {
            str = str + '[' + zone.getID() + ']';
        }
        return str;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase().getZone() == DateTimeZone.UTC) {
            fields.centuryOfEra = new DividedDateTimeField(ISOYearOfEraDateTimeField.INSTANCE, DateTimeFieldType.centuryOfEra(), 100);
            fields.yearOfCentury = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra, DateTimeFieldType.yearOfCentury());
            fields.weekyearOfCentury = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra, DateTimeFieldType.weekyearOfCentury());
            fields.centuries = fields.centuryOfEra.getDurationField();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ISOChronology) {
            ISOChronology chrono = (ISOChronology)obj;
            return this.getZone().equals(chrono.getZone());
        }
        return false;
    }

    public int hashCode() {
        return "ISO".hashCode() * 11 + this.getZone().hashCode();
    }

    private Object writeReplace() {
        return new Stub(this.getZone());
    }

    static {
        cCache = new HashMap<DateTimeZone, ISOChronology>();
        cFastCache = new ISOChronology[64];
        INSTANCE_UTC = new ISOChronology(GregorianChronology.getInstanceUTC());
        cCache.put(DateTimeZone.UTC, INSTANCE_UTC);
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6212696554273812441L;
        private transient DateTimeZone iZone;

        Stub(DateTimeZone zone) {
            this.iZone = zone;
        }

        private Object readResolve() {
            return ISOChronology.getInstance(this.iZone);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.iZone);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.iZone = (DateTimeZone)in.readObject();
        }
    }
}

