/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.convert;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.DateTimeZone;
import com.jn.langx.util.jodatime.PeriodType;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.chrono.ISOChronology;
import com.jn.langx.util.jodatime.convert.Converter;
import com.jn.langx.util.jodatime.format.DateTimeFormatter;

public abstract class AbstractConverter
implements Converter {
    protected AbstractConverter() {
    }

    public long getInstantMillis(Object object, Chronology chrono) {
        return DateTimeUtils.currentTimeMillis();
    }

    public Chronology getChronology(Object object, DateTimeZone zone) {
        return ISOChronology.getInstance(zone);
    }

    public Chronology getChronology(Object object, Chronology chrono) {
        return DateTimeUtils.getChronology(chrono);
    }

    public int[] getPartialValues(ReadablePartial fieldSource, Object object, Chronology chrono) {
        long instant = this.getInstantMillis(object, chrono);
        return chrono.get(fieldSource, instant);
    }

    public int[] getPartialValues(ReadablePartial fieldSource, Object object, Chronology chrono, DateTimeFormatter parser) {
        return this.getPartialValues(fieldSource, object, chrono);
    }

    public PeriodType getPeriodType(Object object) {
        return PeriodType.standard();
    }

    public boolean isReadableInterval(Object object, Chronology chrono) {
        return false;
    }

    public String toString() {
        return "Converter[" + (this.getSupportedType() == null ? "null" : this.getSupportedType().getName()) + "]";
    }
}

