/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.convert;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeZone;
import com.jn.langx.util.jodatime.chrono.BuddhistChronology;
import com.jn.langx.util.jodatime.chrono.GJChronology;
import com.jn.langx.util.jodatime.chrono.GregorianChronology;
import com.jn.langx.util.jodatime.chrono.ISOChronology;
import com.jn.langx.util.jodatime.chrono.JulianChronology;
import com.jn.langx.util.jodatime.convert.AbstractConverter;
import com.jn.langx.util.jodatime.convert.InstantConverter;
import com.jn.langx.util.jodatime.convert.PartialConverter;
import java.util.Calendar;
import java.util.GregorianCalendar;

final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();

    protected CalendarConverter() {
    }

    @Override
    public Chronology getChronology(Object object, Chronology chrono) {
        if (chrono != null) {
            return chrono;
        }
        Calendar cal = (Calendar)object;
        DateTimeZone zone = null;
        try {
            zone = DateTimeZone.forTimeZone(cal.getTimeZone());
        }
        catch (IllegalArgumentException ex) {
            zone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)cal, zone);
    }

    @Override
    public Chronology getChronology(Object object, DateTimeZone zone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(zone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gc = (GregorianCalendar)object;
            long cutover = gc.getGregorianChange().getTime();
            if (cutover == Long.MIN_VALUE) {
                return GregorianChronology.getInstance(zone);
            }
            if (cutover == Long.MAX_VALUE) {
                return JulianChronology.getInstance(zone);
            }
            return GJChronology.getInstance(zone, cutover, 4);
        }
        return ISOChronology.getInstance(zone);
    }

    @Override
    public long getInstantMillis(Object object, Chronology chrono) {
        Calendar calendar = (Calendar)object;
        return calendar.getTime().getTime();
    }

    @Override
    public Class<?> getSupportedType() {
        return Calendar.class;
    }
}

