/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.convert;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.ReadWritableInterval;
import com.jn.langx.util.jodatime.ReadWritablePeriod;
import com.jn.langx.util.jodatime.ReadableInterval;
import com.jn.langx.util.jodatime.convert.AbstractConverter;
import com.jn.langx.util.jodatime.convert.DurationConverter;
import com.jn.langx.util.jodatime.convert.IntervalConverter;
import com.jn.langx.util.jodatime.convert.PeriodConverter;

class ReadableIntervalConverter
extends AbstractConverter
implements IntervalConverter,
DurationConverter,
PeriodConverter {
    static final ReadableIntervalConverter INSTANCE = new ReadableIntervalConverter();

    protected ReadableIntervalConverter() {
    }

    @Override
    public long getDurationMillis(Object object) {
        return ((ReadableInterval)object).toDurationMillis();
    }

    @Override
    public void setInto(ReadWritablePeriod writablePeriod, Object object, Chronology chrono) {
        ReadableInterval interval = (ReadableInterval)object;
        chrono = chrono != null ? chrono : DateTimeUtils.getIntervalChronology(interval);
        long start = interval.getStartMillis();
        long end = interval.getEndMillis();
        int[] values = chrono.get(writablePeriod, start, end);
        for (int i = 0; i < values.length; ++i) {
            writablePeriod.setValue(i, values[i]);
        }
    }

    @Override
    public boolean isReadableInterval(Object object, Chronology chrono) {
        return true;
    }

    @Override
    public void setInto(ReadWritableInterval writableInterval, Object object, Chronology chrono) {
        ReadableInterval input = (ReadableInterval)object;
        writableInterval.setInterval(input);
        if (chrono != null) {
            writableInterval.setChronology(chrono);
        } else {
            writableInterval.setChronology(input.getChronology());
        }
    }

    @Override
    public Class<?> getSupportedType() {
        return ReadableInterval.class;
    }
}

