/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.convert;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTime;
import com.jn.langx.util.jodatime.Period;
import com.jn.langx.util.jodatime.ReadWritableInterval;
import com.jn.langx.util.jodatime.ReadWritablePeriod;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.convert.AbstractConverter;
import com.jn.langx.util.jodatime.convert.DurationConverter;
import com.jn.langx.util.jodatime.convert.InstantConverter;
import com.jn.langx.util.jodatime.convert.IntervalConverter;
import com.jn.langx.util.jodatime.convert.PartialConverter;
import com.jn.langx.util.jodatime.convert.PeriodConverter;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.format.DateTimeFormatter;
import com.jn.langx.util.jodatime.format.ISODateTimeFormat;
import com.jn.langx.util.jodatime.format.ISOPeriodFormat;
import com.jn.langx.util.jodatime.format.PeriodFormatter;

class StringConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter,
DurationConverter,
PeriodConverter,
IntervalConverter {
    static final StringConverter INSTANCE = new StringConverter();

    protected StringConverter() {
    }

    @Override
    public long getInstantMillis(Object object, Chronology chrono) {
        String str = (String)object;
        DateTimeFormatter p = ISODateTimeFormat.dateTimeParser();
        return p.withChronology(chrono).parseMillis(str);
    }

    @Override
    public int[] getPartialValues(ReadablePartial fieldSource, Object object, Chronology chrono, DateTimeFormatter parser) {
        if (parser.getZone() != null) {
            chrono = chrono.withZone(parser.getZone());
        }
        long millis = parser.withChronology(chrono).parseMillis((String)object);
        return chrono.get(fieldSource, millis);
    }

    @Override
    public long getDurationMillis(Object object) {
        int firstDigit;
        String original = (String)object;
        String str = original;
        int len = str.length();
        if (len < 4 || str.charAt(0) != 'P' && str.charAt(0) != 'p' || str.charAt(1) != 'T' && str.charAt(1) != 't' || str.charAt(len - 1) != 'S' && str.charAt(len - 1) != 's') {
            throw new IllegalArgumentException("Invalid format: \"" + original + '\"');
        }
        str = str.substring(2, len - 1);
        int dot = -1;
        boolean negative = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            if (i == 0 && str.charAt(0) == '-') {
                negative = true;
                continue;
            }
            if (i > (negative ? 1 : 0) && str.charAt(i) == '.' && dot == -1) {
                dot = i;
                continue;
            }
            throw new IllegalArgumentException("Invalid format: \"" + original + '\"');
        }
        long millis = 0L;
        long seconds = 0L;
        int n = firstDigit = negative ? 1 : 0;
        if (dot > 0) {
            seconds = Long.parseLong(str.substring(firstDigit, dot));
            if ((str = str.substring(dot + 1)).length() != 3) {
                str = (str + "000").substring(0, 3);
            }
            millis = Integer.parseInt(str);
        } else {
            seconds = negative ? Long.parseLong(str.substring(firstDigit, str.length())) : Long.parseLong(str);
        }
        if (negative) {
            return FieldUtils.safeAdd(FieldUtils.safeMultiply(-seconds, 1000), -millis);
        }
        return FieldUtils.safeAdd(FieldUtils.safeMultiply(seconds, 1000), millis);
    }

    @Override
    public void setInto(ReadWritablePeriod period, Object object, Chronology chrono) {
        String str = (String)object;
        PeriodFormatter parser = ISOPeriodFormat.standard();
        period.clear();
        int pos = parser.parseInto(period, str, 0);
        if (pos < str.length()) {
            if (pos < 0) {
                parser.withParseType(period.getPeriodType()).parseMutablePeriod(str);
            }
            throw new IllegalArgumentException("Invalid format: \"" + str + '\"');
        }
    }

    @Override
    public void setInto(ReadWritableInterval writableInterval, Object object, Chronology chrono) {
        String str = (String)object;
        int separator = str.indexOf(47);
        if (separator < 0) {
            throw new IllegalArgumentException("Format requires a '/' separator: " + str);
        }
        String leftStr = str.substring(0, separator);
        if (leftStr.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + str);
        }
        String rightStr = str.substring(separator + 1);
        if (rightStr.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + str);
        }
        DateTimeFormatter dateTimeParser = ISODateTimeFormat.dateTimeParser();
        dateTimeParser = dateTimeParser.withChronology(chrono);
        PeriodFormatter periodParser = ISOPeriodFormat.standard();
        long startInstant = 0L;
        long endInstant = 0L;
        Period period = null;
        Chronology parsedChrono = null;
        char c = leftStr.charAt(0);
        if (c == 'P' || c == 'p') {
            period = periodParser.withParseType(this.getPeriodType(leftStr)).parsePeriod(leftStr);
        } else {
            DateTime start = dateTimeParser.parseDateTime(leftStr);
            startInstant = start.getMillis();
            parsedChrono = start.getChronology();
        }
        c = rightStr.charAt(0);
        if (c == 'P' || c == 'p') {
            if (period != null) {
                throw new IllegalArgumentException("Interval composed of two durations: " + str);
            }
            period = periodParser.withParseType(this.getPeriodType(rightStr)).parsePeriod(rightStr);
            chrono = chrono != null ? chrono : parsedChrono;
            endInstant = chrono.add(period, startInstant, 1);
        } else {
            DateTime end = dateTimeParser.parseDateTime(rightStr);
            endInstant = end.getMillis();
            parsedChrono = parsedChrono != null ? parsedChrono : end.getChronology();
            Chronology chronology = chrono = chrono != null ? chrono : parsedChrono;
            if (period != null) {
                startInstant = chrono.add(period, endInstant, -1);
            }
        }
        writableInterval.setInterval(startInstant, endInstant);
        writableInterval.setChronology(chrono);
    }

    @Override
    public Class<?> getSupportedType() {
        return String.class;
    }
}

