/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.field;

import com.jn.langx.util.jodatime.DurationField;
import com.jn.langx.util.jodatime.DurationFieldType;
import com.jn.langx.util.jodatime.field.FieldUtils;
import java.io.Serializable;

public abstract class BaseDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = -2554245107589433218L;
    private final DurationFieldType iType;

    protected BaseDurationField(DurationFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = type;
    }

    @Override
    public final DurationFieldType getType() {
        return this.iType;
    }

    @Override
    public final String getName() {
        return this.iType.getName();
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    @Override
    public int getValue(long duration) {
        return FieldUtils.safeToInt(this.getValueAsLong(duration));
    }

    @Override
    public long getValueAsLong(long duration) {
        return duration / this.getUnitMillis();
    }

    @Override
    public int getValue(long duration, long instant) {
        return FieldUtils.safeToInt(this.getValueAsLong(duration, instant));
    }

    @Override
    public long getMillis(int value) {
        return (long)value * this.getUnitMillis();
    }

    @Override
    public long getMillis(long value) {
        return FieldUtils.safeMultiply(value, this.getUnitMillis());
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(minuendInstant, subtrahendInstant));
    }

    @Override
    public int compareTo(DurationField otherField) {
        long otherMillis = otherField.getUnitMillis();
        long thisMillis = this.getUnitMillis();
        if (thisMillis == otherMillis) {
            return 0;
        }
        if (thisMillis < otherMillis) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString() {
        return "DurationField[" + this.getName() + ']';
    }
}

