/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.field;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeField;
import com.jn.langx.util.jodatime.field.DelegatedDateTimeField;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.field.StrictDateTimeField;

public class LenientDateTimeField
extends DelegatedDateTimeField {
    private static final long serialVersionUID = 8714085824173290599L;
    private final Chronology iBase;

    public static DateTimeField getInstance(DateTimeField field, Chronology base) {
        if (field == null) {
            return null;
        }
        if (field instanceof StrictDateTimeField) {
            field = ((StrictDateTimeField)field).getWrappedField();
        }
        if (field.isLenient()) {
            return field;
        }
        return new LenientDateTimeField(field, base);
    }

    protected LenientDateTimeField(DateTimeField field, Chronology base) {
        super(field);
        this.iBase = base;
    }

    @Override
    public final boolean isLenient() {
        return true;
    }

    @Override
    public long set(long instant, int value) {
        long localInstant = this.iBase.getZone().convertUTCToLocal(instant);
        long difference = FieldUtils.safeSubtract(value, this.get(instant));
        localInstant = this.getType().getField(this.iBase.withUTC()).add(localInstant, difference);
        return this.iBase.getZone().convertLocalToUTC(localInstant, false, instant);
    }
}

