/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.field;

import com.jn.langx.util.jodatime.DateTimeField;
import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DurationField;
import com.jn.langx.util.jodatime.field.DecoratedDateTimeField;
import com.jn.langx.util.jodatime.field.FieldUtils;

public class OffsetDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 3145790132623583142L;
    private final int iOffset;
    private final int iMin;
    private final int iMax;

    public OffsetDateTimeField(DateTimeField field, int offset) {
        this(field, field == null ? null : field.getType(), offset, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public OffsetDateTimeField(DateTimeField field, DateTimeFieldType type, int offset) {
        this(field, type, offset, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public OffsetDateTimeField(DateTimeField field, DateTimeFieldType type, int offset, int minValue, int maxValue) {
        super(field, type);
        if (offset == 0) {
            throw new IllegalArgumentException("The offset cannot be zero");
        }
        this.iOffset = offset;
        this.iMin = minValue < field.getMinimumValue() + offset ? field.getMinimumValue() + offset : minValue;
        this.iMax = maxValue > field.getMaximumValue() + offset ? field.getMaximumValue() + offset : maxValue;
    }

    @Override
    public int get(long instant) {
        return super.get(instant) + this.iOffset;
    }

    @Override
    public long add(long instant, int amount) {
        instant = super.add(instant, amount);
        FieldUtils.verifyValueBounds(this, this.get(instant), this.iMin, this.iMax);
        return instant;
    }

    @Override
    public long add(long instant, long amount) {
        instant = super.add(instant, amount);
        FieldUtils.verifyValueBounds(this, this.get(instant), this.iMin, this.iMax);
        return instant;
    }

    @Override
    public long addWrapField(long instant, int amount) {
        return this.set(instant, FieldUtils.getWrappedValue(this.get(instant), amount, this.iMin, this.iMax));
    }

    @Override
    public long set(long instant, int value) {
        FieldUtils.verifyValueBounds(this, value, this.iMin, this.iMax);
        return super.set(instant, value - this.iOffset);
    }

    @Override
    public boolean isLeap(long instant) {
        return this.getWrappedField().isLeap(instant);
    }

    @Override
    public int getLeapAmount(long instant) {
        return this.getWrappedField().getLeapAmount(instant);
    }

    @Override
    public DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    @Override
    public int getMinimumValue() {
        return this.iMin;
    }

    @Override
    public int getMaximumValue() {
        return this.iMax;
    }

    @Override
    public long roundFloor(long instant) {
        return this.getWrappedField().roundFloor(instant);
    }

    @Override
    public long roundCeiling(long instant) {
        return this.getWrappedField().roundCeiling(instant);
    }

    @Override
    public long roundHalfFloor(long instant) {
        return this.getWrappedField().roundHalfFloor(instant);
    }

    @Override
    public long roundHalfCeiling(long instant) {
        return this.getWrappedField().roundHalfCeiling(instant);
    }

    @Override
    public long roundHalfEven(long instant) {
        return this.getWrappedField().roundHalfEven(instant);
    }

    @Override
    public long remainder(long instant) {
        return this.getWrappedField().remainder(instant);
    }

    public int getOffset() {
        return this.iOffset;
    }
}

