/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.field;

import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DurationField;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.field.PreciseDurationDateTimeField;

public class PreciseDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -5586801265774496376L;
    private final int iRange;
    private final DurationField iRangeField;

    public PreciseDateTimeField(DateTimeFieldType type, DurationField unit, DurationField range) {
        super(type, unit);
        if (!range.isPrecise()) {
            throw new IllegalArgumentException("Range duration field must be precise");
        }
        long rangeMillis = range.getUnitMillis();
        this.iRange = (int)(rangeMillis / this.getUnitMillis());
        if (this.iRange < 2) {
            throw new IllegalArgumentException("The effective range must be at least 2");
        }
        this.iRangeField = range;
    }

    @Override
    public int get(long instant) {
        if (instant >= 0L) {
            return (int)(instant / this.getUnitMillis() % (long)this.iRange);
        }
        return this.iRange - 1 + (int)((instant + 1L) / this.getUnitMillis() % (long)this.iRange);
    }

    @Override
    public long addWrapField(long instant, int amount) {
        int thisValue = this.get(instant);
        int wrappedValue = FieldUtils.getWrappedValue(thisValue, amount, this.getMinimumValue(), this.getMaximumValue());
        return instant + (long)(wrappedValue - thisValue) * this.getUnitMillis();
    }

    @Override
    public long set(long instant, int value) {
        FieldUtils.verifyValueBounds(this, value, this.getMinimumValue(), this.getMaximumValue());
        return instant + (long)(value - this.get(instant)) * this.iUnitMillis;
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    @Override
    public int getMaximumValue() {
        return this.iRange - 1;
    }

    public int getRange() {
        return this.iRange;
    }
}

