/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.field;

import com.jn.langx.util.jodatime.DateTimeField;
import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DurationField;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.field.DecoratedDateTimeField;
import com.jn.langx.util.jodatime.field.FieldUtils;

public final class ZeroIsMaxDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 961749798233026866L;

    public ZeroIsMaxDateTimeField(DateTimeField field, DateTimeFieldType type) {
        super(field, type);
        if (field.getMinimumValue() != 0) {
            throw new IllegalArgumentException("Wrapped field's minumum value must be zero");
        }
    }

    @Override
    public int get(long instant) {
        int value = this.getWrappedField().get(instant);
        if (value == 0) {
            value = this.getMaximumValue();
        }
        return value;
    }

    @Override
    public long add(long instant, int value) {
        return this.getWrappedField().add(instant, value);
    }

    @Override
    public long add(long instant, long value) {
        return this.getWrappedField().add(instant, value);
    }

    @Override
    public long addWrapField(long instant, int value) {
        return this.getWrappedField().addWrapField(instant, value);
    }

    @Override
    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        return this.getWrappedField().addWrapField(instant, fieldIndex, values, valueToAdd);
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifference(minuendInstant, subtrahendInstant);
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    @Override
    public long set(long instant, int value) {
        int max = this.getMaximumValue();
        FieldUtils.verifyValueBounds(this, value, 1, max);
        if (value == max) {
            value = 0;
        }
        return this.getWrappedField().set(instant, value);
    }

    @Override
    public boolean isLeap(long instant) {
        return this.getWrappedField().isLeap(instant);
    }

    @Override
    public int getLeapAmount(long instant) {
        return this.getWrappedField().getLeapAmount(instant);
    }

    @Override
    public DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMinimumValue(long instant) {
        return 1;
    }

    @Override
    public int getMinimumValue(ReadablePartial instant) {
        return 1;
    }

    @Override
    public int getMinimumValue(ReadablePartial instant, int[] values) {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return this.getWrappedField().getMaximumValue() + 1;
    }

    @Override
    public int getMaximumValue(long instant) {
        return this.getWrappedField().getMaximumValue(instant) + 1;
    }

    @Override
    public int getMaximumValue(ReadablePartial instant) {
        return this.getWrappedField().getMaximumValue(instant) + 1;
    }

    @Override
    public int getMaximumValue(ReadablePartial instant, int[] values) {
        return this.getWrappedField().getMaximumValue(instant, values) + 1;
    }

    @Override
    public long roundFloor(long instant) {
        return this.getWrappedField().roundFloor(instant);
    }

    @Override
    public long roundCeiling(long instant) {
        return this.getWrappedField().roundCeiling(instant);
    }

    @Override
    public long roundHalfFloor(long instant) {
        return this.getWrappedField().roundHalfFloor(instant);
    }

    @Override
    public long roundHalfCeiling(long instant) {
        return this.getWrappedField().roundHalfCeiling(instant);
    }

    @Override
    public long roundHalfEven(long instant) {
        return this.getWrappedField().roundHalfEven(instant);
    }

    @Override
    public long remainder(long instant) {
        return this.getWrappedField().remainder(instant);
    }
}

