/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.leak;

import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.leak.ResourceLeakDetector;
import com.jn.langx.util.leak.ResourceLeakDetectorFactory;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceLeakDetectorFactory
extends ResourceLeakDetectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResourceLeakDetectorFactory.class);
    private final Constructor<?> obsoleteCustomClassConstructor;
    private final Constructor<?> customClassConstructor;

    public DefaultResourceLeakDetectorFactory() {
        String customLeakDetector;
        try {
            customLeakDetector = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return SystemPropertys.getAccessor().getString("io.netty.customResourceLeakDetector");
                }
            });
        }
        catch (Throwable cause) {
            logger.error("Could not access System property: io.netty.customResourceLeakDetector", cause);
            customLeakDetector = null;
        }
        if (customLeakDetector == null) {
            this.customClassConstructor = null;
            this.obsoleteCustomClassConstructor = null;
        } else {
            this.obsoleteCustomClassConstructor = DefaultResourceLeakDetectorFactory.obsoleteCustomClassConstructor(customLeakDetector);
            this.customClassConstructor = DefaultResourceLeakDetectorFactory.customClassConstructor(customLeakDetector);
        }
    }

    private static Constructor<?> obsoleteCustomClassConstructor(String customLeakDetector) {
        try {
            Class<?> detectorClass = Class.forName(customLeakDetector, true, ClassLoader.getSystemClassLoader());
            if (ResourceLeakDetector.class.isAssignableFrom(detectorClass)) {
                return detectorClass.getConstructor(Class.class, Integer.TYPE, Long.TYPE);
            }
            logger.error("Class {} does not inherit from ResourceLeakDetector.", (Object)customLeakDetector);
        }
        catch (Throwable t) {
            logger.error("Could not load custom resource leak detector class provided: {}", (Object)customLeakDetector, (Object)t);
        }
        return null;
    }

    private static Constructor<?> customClassConstructor(String customLeakDetector) {
        try {
            Class<?> detectorClass = Class.forName(customLeakDetector, true, ClassLoader.getSystemClassLoader());
            if (ResourceLeakDetector.class.isAssignableFrom(detectorClass)) {
                return detectorClass.getConstructor(Class.class, Integer.TYPE);
            }
            logger.error("Class {} does not inherit from ResourceLeakDetector.", (Object)customLeakDetector);
        }
        catch (Throwable t) {
            logger.error("Could not load custom resource leak detector class provided: {}", (Object)customLeakDetector, (Object)t);
        }
        return null;
    }

    @Override
    public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval) {
        if (this.customClassConstructor != null) {
            try {
                ResourceLeakDetector leakDetector = (ResourceLeakDetector)this.customClassConstructor.newInstance(resource, samplingInterval);
                logger.debug("Loaded custom ResourceLeakDetector: {}", (Object)this.customClassConstructor.getDeclaringClass().getName());
                return leakDetector;
            }
            catch (Throwable t) {
                logger.error("Could not load custom resource leak detector provided: {} with the given resource: {}", new Object[]{this.customClassConstructor.getDeclaringClass().getName(), resource, t});
            }
        }
        ResourceLeakDetector resourceLeakDetector = new ResourceLeakDetector(resource, samplingInterval);
        logger.debug("Loaded default ResourceLeakDetector: {}", resourceLeakDetector);
        return resourceLeakDetector;
    }
}

