/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.leak;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.leak.DefaultResourceLeakDetectorFactory;
import com.jn.langx.util.leak.ResourceLeakDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceLeakDetectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLeakDetectorFactory.class);
    private static volatile ResourceLeakDetectorFactory factoryInstance = new DefaultResourceLeakDetectorFactory();

    public static ResourceLeakDetectorFactory instance() {
        return factoryInstance;
    }

    public static void setResourceLeakDetectorFactory(ResourceLeakDetectorFactory factory) {
        factoryInstance = Preconditions.checkNotNull(factory, "factory");
    }

    public final <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource) {
        return this.newResourceLeakDetector(resource, ResourceLeakDetector.SAMPLING_INTERVAL);
    }

    public abstract <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> var1, int var2);
}

