/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.script.javascript.regexp;

import com.jn.langx.util.script.ScriptLanguage;
import com.jn.langx.util.script.SimpleScriptEngineFactory;
import com.jn.langx.util.script.javascript.regexp.RegexpPatternException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class RegExp {
    public static final String URL = "";
    public static final String EMAIL = "^[a-z\\d]+(\\.[a-z\\d]+)*@([\\da-z](-[\\da-z])?)+(\\.{1,2}[a-z]+)+$";
    public static final String CHINESE = "[\u4e00-\u9fa5]";
    public static final String JsTestMethod = "test";
    public static final String TEL = "^((86|\\+86)?1)[358]\\d{9}$|^(\\d{3,4}-)?\\d{7,8}(-\\d{1,4})?$";
    private String pattern = "";
    private boolean isIgnoreCase = false;

    public static Matcher getMatcher(String pattern, String src) {
        return Pattern.compile(pattern).matcher(src);
    }

    public RegExp(String pattern) {
        this.pattern = pattern;
    }

    public RegExp(String pattern, boolean ignore) {
        this.pattern = pattern;
        this.isIgnoreCase = ignore;
    }

    public void setIgnoreCase(boolean ignore) {
        this.isIgnoreCase = ignore;
    }

    public boolean test(String str) {
        if (this.isIgnoreCase) {
            try {
                ScriptEngine engine = SimpleScriptEngineFactory.getScriptEngine(ScriptLanguage.JavaScript);
                String script = "var reg=/" + this.pattern + "/gi;";
                engine.eval(script);
                Object regexp = engine.get("reg");
                Invocable inv = (Invocable)((Object)engine);
                Object returnValue = inv.invokeMethod(regexp, JsTestMethod, str);
                Boolean match = (Boolean)returnValue;
                return match;
            }
            catch (Exception e) {
                throw new RegexpPatternException(this.pattern);
            }
        }
        return str.matches(this.pattern);
    }

    public Object test(String str, MutilTest mutilTest) {
        if (this.isIgnoreCase) {
            try {
                ScriptEngine engine = SimpleScriptEngineFactory.getScriptEngine(ScriptLanguage.JavaScript);
                String script = "var reg=/" + this.pattern + "/gi;";
                engine.eval(script);
                Object regexp = engine.get("reg");
                Invocable inv = (Invocable)((Object)engine);
                return mutilTest.invoke(inv, regexp, new Object[]{str});
            }
            catch (Exception e) {
                throw new RegexpPatternException(this.pattern);
            }
        }
        return str.matches(this.pattern);
    }

    public static void main(String[] args) {
        String src = "Java,javawoefsflewjoavejavaejsjavajavajavajavajavajavaeajavja";
        RegExp regexp = new RegExp("java", true);
        int count = (Integer)regexp.test(src, new MutilTest(){

            @Override
            public Object invoke(Invocable engine, Object jsRegexp, Object[] params) {
                int i = 0;
                try {
                    while (((Boolean)engine.invokeMethod(jsRegexp, RegExp.JsTestMethod, params)).booleanValue()) {
                        ++i;
                    }
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                return i;
            }
        });
        System.out.println(count);
    }

    static interface MutilTest {
        public Object invoke(Invocable var1, Object var2, Object[] var3);
    }
}

