/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.struct;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.struct.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Entry<K, V>
extends Pair<K, V>
implements Map.Entry<K, V> {
    public Entry(K key) {
        this.setKey(key);
    }

    public Entry(K key, V value) {
        this.setKey(key);
        this.setValue(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entry)) {
            return false;
        }
        Entry o = (Entry)obj;
        return this.getKey().equals(o.getKey()) && this.getValue().equals(o.getValue());
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode() ^ 4 + this.getValue().hashCode();
    }

    public static Entry<String, String> newEntry(String keyValue, String spec) throws IllegalArgumentException {
        if (Emptys.isEmpty(spec)) {
            throw new IllegalArgumentException("argument 'spec' is null .");
        }
        if (Emptys.isEmpty(keyValue)) {
            throw new IllegalArgumentException("argument 'keyValue' is null .");
        }
        int index = keyValue.indexOf(spec);
        if (index == -1) {
            return new Entry<String, String>(keyValue.trim(), "");
        }
        return new Entry<String, String>(keyValue.substring(0, index).trim(), keyValue.substring(index + spec.length()).trim());
    }

    public static Map<String, String> getMap(String str, String keyValueSpec, String entrySpec) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (Emptys.isEmpty(str)) {
            return map;
        }
        String[] entryArray = str.split(entrySpec);
        Entry<String, String> entry = null;
        for (String keyValue : entryArray) {
            try {
                entry = Entry.newEntry(keyValue, keyValueSpec);
            }
            catch (IllegalArgumentException ex) {
                entry = null;
            }
            if (entry == null) continue;
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    public static List<Map<String, String>> getMapList(String src, String keyValueSpec, String entrySpec, String listSpecFlag) {
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (Emptys.isEmpty(listSpecFlag)) {
            strList.add(src);
        } else {
            int index = src.indexOf(listSpecFlag);
            if (index == -1) {
                return list;
            }
            int nextIndex = -1;
            while ((nextIndex = src.indexOf(listSpecFlag, index + listSpecFlag.length())) != -1) {
                strList.add(src.substring(index, nextIndex));
                index = nextIndex;
            }
            strList.add(src.substring(index));
        }
        for (String str : strList) {
            Map<String, String> map = Entry.getMap(str, keyValueSpec, entrySpec);
            list.add(map);
        }
        return list;
    }
}

