/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.cron.parser;

import com.jn.langx.util.Strings;
import com.jn.langx.util.jodatime.DateTime;
import com.jn.langx.util.jodatime.LocalTime;
import com.jn.langx.util.jodatime.format.DateTimeFormat;
import com.jn.langx.util.jodatime.format.DateTimeFormatter;
import com.jn.langx.util.timing.cron.parser.CronI18nMessages;
import com.jn.langx.util.timing.cron.parser.Options;

public final class DateAndTimeUtils {
    private DateAndTimeUtils() {
    }

    public static String formatTime(String hoursExpression, String minutesExpression, Options opts) {
        return DateAndTimeUtils.formatTime(hoursExpression, minutesExpression, "", opts);
    }

    public static String formatTime(String hoursExpression, String minutesExpression, String secondsExpression, Options opts) {
        DateTimeFormatter timeFormat;
        LocalTime localTime;
        int hour = Integer.parseInt(hoursExpression);
        int minutes = Integer.parseInt(minutesExpression);
        if (opts.isTwentyFourHourTime()) {
            if (!Strings.isEmpty(secondsExpression)) {
                int seconds = Integer.parseInt(secondsExpression);
                localTime = new LocalTime(hour, minutes, seconds);
                timeFormat = DateTimeFormat.mediumTime();
            } else {
                localTime = new LocalTime(hour, minutes);
                timeFormat = DateTimeFormat.shortTime();
            }
        } else if (!Strings.isEmpty(secondsExpression)) {
            int seconds = Integer.parseInt(secondsExpression);
            localTime = new LocalTime(hour, minutes, seconds);
            timeFormat = DateTimeFormat.forPattern("h:mm:ss a");
        } else {
            localTime = new LocalTime(hour, minutes);
            timeFormat = DateTimeFormat.forPattern("h:mm a");
        }
        return localTime.toString(timeFormat.withLocale(CronI18nMessages.getCurrentLocale()));
    }

    public static String getDayOfWeekName(int dayOfWeek) {
        return new DateTime().withDayOfWeek(dayOfWeek).dayOfWeek().getAsText(CronI18nMessages.getCurrentLocale());
    }

    public static String formatMinutes(String minutesExpression) {
        if (minutesExpression.contains(",")) {
            StringBuilder formattedExpression = new StringBuilder();
            for (String minute : Strings.split(minutesExpression, ",")) {
                formattedExpression.append(Strings.leftPad(minute, 2, '0'));
                formattedExpression.append(",");
            }
            return formattedExpression.toString();
        }
        return Strings.leftPad(minutesExpression, 2, '0');
    }
}

