/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.cron.parser;

import com.jn.langx.util.Strings;
import com.jn.langx.util.jodatime.DateTime;
import com.jn.langx.util.timing.cron.parser.CronI18nMessages;
import com.jn.langx.util.timing.cron.parser.DateAndTimeUtils;
import com.jn.langx.util.timing.cron.parser.Options;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Pattern;

public class ExpressionParser {
    static final Pattern yearRegex = Pattern.compile("(.*)\\d{4}$");

    private ExpressionParser() {
    }

    @Deprecated
    public static String[] parse(String expression) throws ParseException {
        return ExpressionParser.parse(expression, null);
    }

    public static String[] parse(String expression, Options options) throws ParseException {
        String[] parsed = new String[]{"", "", "", "", "", "", ""};
        if (Strings.isEmpty(expression)) {
            throw new IllegalArgumentException(CronI18nMessages.get("expression_empty_exception"));
        }
        String[] expressionParts = expression.split(" ");
        if (expressionParts.length < 5) {
            throw new ParseException(expression, 0);
        }
        if (expressionParts.length == 5) {
            parsed[0] = "";
            System.arraycopy(expressionParts, 0, parsed, 1, 5);
        } else if (expressionParts.length == 6) {
            if (yearRegex.matcher(expressionParts[5]).matches()) {
                System.arraycopy(expressionParts, 0, parsed, 1, 6);
            } else {
                System.arraycopy(expressionParts, 0, parsed, 0, 6);
            }
        } else if (expressionParts.length == 7) {
            parsed = expressionParts;
        } else {
            throw new ParseException(expression, 7);
        }
        ExpressionParser.normaliseExpression(parsed, options);
        return parsed;
    }

    private static void normaliseExpression(String[] expressionParts, Options options) {
        int i;
        expressionParts[3] = expressionParts[3].replace('?', '*');
        expressionParts[5] = expressionParts[5].replace('?', '*');
        expressionParts[0] = expressionParts[0].startsWith("0/") ? expressionParts[0].replace("0/", "*/") : expressionParts[0];
        expressionParts[1] = expressionParts[1].startsWith("0/") ? expressionParts[1].replace("0/", "*/") : expressionParts[1];
        expressionParts[2] = expressionParts[2].startsWith("0/") ? expressionParts[2].replace("0/", "*/") : expressionParts[2];
        expressionParts[3] = expressionParts[3].startsWith("1/") ? expressionParts[3].replace("1/", "*/") : expressionParts[3];
        expressionParts[4] = expressionParts[4].startsWith("1/") ? expressionParts[4].replace("1/", "*/") : expressionParts[4];
        expressionParts[5] = expressionParts[5].startsWith("1/") ? expressionParts[5].replace("1/", "*/") : expressionParts[5];
        for (i = 0; i < expressionParts.length; ++i) {
            if (!"*/1".equals(expressionParts[i])) continue;
            expressionParts[i] = "*";
        }
        if (!Strings.isNumeric(expressionParts[5])) {
            for (i = 0; i <= 6; ++i) {
                expressionParts[5] = expressionParts[5].replace(DateAndTimeUtils.getDayOfWeekName(i + 1), String.valueOf(i));
            }
        }
        if (!Strings.isNumeric(expressionParts[4])) {
            for (i = 1; i <= 12; ++i) {
                DateTime currentMonth = new DateTime().withDayOfMonth(1).withMonthOfYear(i);
                String currentMonthDescription = currentMonth.toString("MMM", Locale.ENGLISH).toUpperCase();
                expressionParts[4] = expressionParts[4].replace(currentMonthDescription, String.valueOf(i));
            }
        }
        if ("0".equals(expressionParts[0])) {
            expressionParts[0] = "";
        }
        if ((options == null || options.isZeroBasedDayOfWeek()) && "0".equals(expressionParts[5])) {
            expressionParts[5] = "7";
        }
    }
}

