/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.cron.parser.builder;

import com.jn.langx.util.Strings;
import com.jn.langx.util.WordUtils;
import com.jn.langx.util.jodatime.format.DateTimeFormat;
import com.jn.langx.util.jodatime.format.DateTimeFormatter;
import com.jn.langx.util.timing.cron.parser.CronI18nMessages;
import com.jn.langx.util.timing.cron.parser.DateAndTimeUtils;
import com.jn.langx.util.timing.cron.parser.Options;
import com.jn.langx.util.timing.cron.parser.builder.AbstractDescriptionBuilder;
import java.text.MessageFormat;
import java.util.Locale;

public class DayOfWeekDescriptionBuilder
extends AbstractDescriptionBuilder {
    private final Options options;

    @Deprecated
    public DayOfWeekDescriptionBuilder() {
        this.options = null;
    }

    public DayOfWeekDescriptionBuilder(Options options) {
        this.options = options;
    }

    @Override
    protected String getSingleItemDescription(String expression) {
        String exp = expression;
        if (expression.contains("#")) {
            exp = expression.substring(0, expression.indexOf("#"));
        } else if (expression.contains("L")) {
            exp = exp.replace("L", "");
        }
        if (Strings.isNumeric(exp)) {
            boolean isInvalidDayOfWeekForSetting;
            int dayOfWeekNum = Integer.parseInt(exp);
            boolean isZeroBasedDayOfWeek = this.options == null || this.options.isZeroBasedDayOfWeek();
            boolean bl = isInvalidDayOfWeekForSetting = this.options != null && !this.options.isZeroBasedDayOfWeek() && dayOfWeekNum <= 1;
            if (isInvalidDayOfWeekForSetting || isZeroBasedDayOfWeek && dayOfWeekNum == 0) {
                return DateAndTimeUtils.getDayOfWeekName(7);
            }
            if (this.options != null && !this.options.isZeroBasedDayOfWeek()) {
                --dayOfWeekNum;
            }
            return DateAndTimeUtils.getDayOfWeekName(dayOfWeekNum);
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern("EEE").withLocale(Locale.ENGLISH);
        return dateTimeFormatter.parseDateTime(WordUtils.capitalizeFully(exp)).dayOfWeek().getAsText(CronI18nMessages.getCurrentLocale());
    }

    @Override
    protected String getIntervalDescriptionFormat(String expression) {
        return MessageFormat.format(", " + CronI18nMessages.get("interval_description_format"), expression);
    }

    @Override
    protected String getBetweenDescriptionFormat(String expression, boolean omitSeparator) {
        String format = CronI18nMessages.get("between_weekday_description_format");
        return omitSeparator ? format : ", " + format;
    }

    @Override
    protected String getDescriptionFormat(String expression) {
        String format = null;
        if (expression.contains("#")) {
            String dayOfWeekOfMonthNumber = expression.substring(expression.indexOf("#") + 1);
            String dayOfWeekOfMonthDescription = "";
            if ("1".equals(dayOfWeekOfMonthNumber)) {
                dayOfWeekOfMonthDescription = CronI18nMessages.get("first");
            } else if ("2".equals(dayOfWeekOfMonthNumber)) {
                dayOfWeekOfMonthDescription = CronI18nMessages.get("second");
            } else if ("3".equals(dayOfWeekOfMonthNumber)) {
                dayOfWeekOfMonthDescription = CronI18nMessages.get("third");
            } else if ("4".equals(dayOfWeekOfMonthNumber)) {
                dayOfWeekOfMonthDescription = CronI18nMessages.get("fourth");
            } else if ("5".equals(dayOfWeekOfMonthNumber)) {
                dayOfWeekOfMonthDescription = CronI18nMessages.get("fifth");
            }
            format = ", " + String.format(CronI18nMessages.get("on_the_day_of_the_month"), dayOfWeekOfMonthDescription);
        } else {
            format = expression.contains("L") ? ", " + CronI18nMessages.get("on_the_last_of_the_month") : ", " + CronI18nMessages.get("only_on");
        }
        return format;
    }

    @Override
    protected Boolean needSpaceBetweenWords() {
        return this.options.isNeedSpaceBetweenWords();
    }
}

