/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.cron.parser.builder;

import com.jn.langx.util.timing.cron.parser.CronI18nMessages;
import com.jn.langx.util.timing.cron.parser.DateAndTimeUtils;
import com.jn.langx.util.timing.cron.parser.Options;
import com.jn.langx.util.timing.cron.parser.builder.AbstractDescriptionBuilder;
import java.text.MessageFormat;

public class HoursDescriptionBuilder
extends AbstractDescriptionBuilder {
    private final Options options;

    public HoursDescriptionBuilder(Options options) {
        this.options = options;
    }

    @Override
    protected String getSingleItemDescription(String expression) {
        return DateAndTimeUtils.formatTime(expression, "0", this.options);
    }

    @Override
    protected String getIntervalDescriptionFormat(String expression) {
        return MessageFormat.format(CronI18nMessages.get("every_x") + this.getSpace(this.options) + this.plural(expression, CronI18nMessages.get("hour"), CronI18nMessages.get("hours")), expression);
    }

    @Override
    protected String getBetweenDescriptionFormat(String expression, boolean omitSeparator) {
        return CronI18nMessages.get("between_x_and_y");
    }

    @Override
    protected String getDescriptionFormat(String expression) {
        return CronI18nMessages.get("at_x");
    }

    @Override
    protected Boolean needSpaceBetweenWords() {
        return this.options.isNeedSpaceBetweenWords();
    }
}

