/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.cron.parser.builder;

import com.jn.langx.util.timing.cron.parser.CronI18nMessages;
import com.jn.langx.util.timing.cron.parser.DateAndTimeUtils;
import com.jn.langx.util.timing.cron.parser.Options;
import com.jn.langx.util.timing.cron.parser.builder.AbstractDescriptionBuilder;
import java.text.MessageFormat;

public class MinutesDescriptionBuilder
extends AbstractDescriptionBuilder {
    private final Options options;

    public MinutesDescriptionBuilder(Options options) {
        this.options = options;
    }

    @Override
    protected String getSingleItemDescription(String expression) {
        return DateAndTimeUtils.formatMinutes(expression);
    }

    @Override
    protected String getIntervalDescriptionFormat(String expression) {
        return MessageFormat.format(CronI18nMessages.get("every_x") + this.getSpace(this.options) + this.minPlural(expression), expression);
    }

    @Override
    protected String getBetweenDescriptionFormat(String expression, boolean omitSeparator) {
        return CronI18nMessages.get("minutes_through_past_the_hour");
    }

    @Override
    protected String getDescriptionFormat(String expression) {
        return "0".equals(expression) ? "" : CronI18nMessages.get("at_x") + this.getSpace(this.options) + this.minPlural(expression) + this.getSpace(this.options) + CronI18nMessages.get("past_the_hour");
    }

    @Override
    protected Boolean needSpaceBetweenWords() {
        return this.options.isNeedSpaceBetweenWords();
    }

    private String minPlural(String expression) {
        return this.plural(expression, CronI18nMessages.get("minute"), CronI18nMessages.get("minutes"));
    }
}

