/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.xml;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.xml.XmlDocumentHandler;
import com.jn.langx.util.xml.Xmls;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlAccessor {
    private static final Logger logger = LoggerFactory.getLogger(XmlAccessor.class);

    public void setElementAttribute(Document doc, XPathFactory factory, String elementXpath, String attributeName, String attributeValue) throws Exception {
        if (Emptys.isEmpty(attributeName)) {
            return;
        }
        try {
            Element element = this.getElement(doc, factory, elementXpath);
            if (Emptys.isEmpty(element)) {
                return;
            }
            element.setAttribute(attributeName, attributeValue);
            if (logger.isDebugEnabled()) {
                logger.debug("set attribute " + attributeName + "=" + attributeValue + "for element " + elementXpath);
            }
        }
        catch (Exception ex) {
            logger.error("Error occur when set attribute {} for element {}", (Object)attributeName, (Object)elementXpath);
            throw ex;
        }
    }

    protected Element getElement(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        XPath xpath = factory.newXPath();
        XPathExpression exp = xpath.compile(elementXpath);
        return (Element)exp.evaluate(doc, XPathConstants.NODE);
    }

    public void setElementAttributes(Document doc, XPathFactory factory, String elementXpath, Map<String, String> attrs) throws Exception {
        if (Emptys.isEmpty(attrs)) {
            return;
        }
        try {
            Element element = this.getElement(doc, factory, elementXpath);
            if (Emptys.isEmpty(element)) {
                return;
            }
            for (String attributeName : attrs.keySet()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("set attribute " + attributeName + "=" + attrs.get(attributeName) + "for element " + elementXpath);
                }
                element.setAttribute(attributeName, attrs.get(attributeName));
            }
        }
        catch (Exception ex) {
            logger.error("Error occur when set attribute for element {}", (Object)elementXpath);
            throw ex;
        }
    }

    public void setElementsAttributes(Document doc, XPathFactory factory, String elementXpath, Map<String, String> attrs) throws Exception {
        if (Emptys.isEmpty(attrs)) {
            return;
        }
        try {
            NodeList elements = this.getNodeList(doc, factory, elementXpath);
            if (Emptys.isEmpty(elements)) {
                return;
            }
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element = (Element)elements.item(i);
                for (String attributeName : attrs.keySet()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("set attribute " + attributeName + "=" + attrs.get(attributeName) + "for element " + elementXpath);
                    }
                    element.setAttribute(attributeName, attrs.get(attributeName));
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error occur when set attribute for element {}", (Object)elementXpath);
            throw ex;
        }
    }

    public String getElementAttribute(String xmlFilePath, final String elementXpath, final String attributeName) throws Exception {
        return Xmls.handleXml(xmlFilePath, new XmlDocumentHandler<String>(){

            @Override
            public String handle(Document doc) throws Exception {
                XPathFactory factory = XPathFactory.newInstance();
                return XmlAccessor.this.getElementAttribute(doc, factory, elementXpath, attributeName);
            }
        });
    }

    public String getElementAttribute(Document doc, XPathFactory factory, String elementXpath, String attributeName) throws Exception {
        try {
            String ret;
            if (Emptys.isEmpty(attributeName)) {
                throw new IllegalArgumentException("attributeName is empty .");
            }
            Element element = this.getElement(doc, factory, elementXpath);
            Attr attr = element.getAttributeNode(attributeName);
            String string = ret = Emptys.isEmpty(attr) ? "" : attr.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("get attribute " + attributeName + " from " + elementXpath + " is " + ret);
            }
            return ret;
        }
        catch (Exception ex) {
            logger.error("Error occur when get attribute {} from element {}", (Object)attributeName, (Object)elementXpath);
            throw ex;
        }
    }

    public NodeList getNodeList(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        XPath xpath = factory.newXPath();
        XPathExpression exp = xpath.compile(elementXpath);
        return (NodeList)exp.evaluate(doc, XPathConstants.NODESET);
    }
}

