/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.xml;

import com.jn.langx.util.xml.XmlDocumentHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Xmls {
    private static final String NULL_XML_STR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public static Document getXmlDoc(EntityResolver entityResolver, InputStream xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(false);
        factory.setNamespaceAware(true);
        if (entityResolver != null) {
            factory.setValidating(true);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        entityResolver = entityResolver == null ? new NullEntityResolver() : entityResolver;
        builder.setEntityResolver(entityResolver);
        builder.setErrorHandler(new ErrorHandler());
        return builder.parse(xml);
    }

    public static Document getXmlDoc(InputStream dtdInputStream, String src, boolean srcIsPath) throws Exception {
        if (srcIsPath) {
            return Xmls.getXmlDoc(dtdInputStream, src);
        }
        return Xmls.getXmlDoc(new DTDEntityResolver(dtdInputStream), new ByteArrayInputStream(src.getBytes()));
    }

    public static Document getXmlDoc(InputStream dtdInputStream, String xmlfilepathOrURI) throws Exception {
        File file = new File(xmlfilepathOrURI);
        if (!file.exists()) {
            throw new FileNotFoundException("File '" + xmlfilepathOrURI + "' does not exist .");
        }
        return Xmls.getXmlDoc(new DTDEntityResolver(dtdInputStream), new FileInputStream(file));
    }

    public static void writeDocToOutputStream(Document doc, OutputStream out) throws Exception {
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(out));
    }

    public static void writeDocToFile(Document doc, File file) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(file));
    }

    public static <T> T handleXml(String xmlpath, XmlDocumentHandler<T> handler) throws Exception {
        T t;
        InputStream input = null;
        Document doc = null;
        try {
            File file = new File(xmlpath);
            if (!file.exists()) {
                throw new FileNotFoundException("File '" + xmlpath + "' does not exist .");
            }
            input = new FileInputStream(file);
            doc = Xmls.getXmlDoc(null, input);
            t = handler.handle(doc);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return t;
    }

    public static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    public static class NullEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(Xmls.NULL_XML_STR.getBytes()));
        }
    }

    public static class DTDEntityResolver
    implements EntityResolver {
        private InputStream dtdInputStream;

        public DTDEntityResolver(InputStream dtdInputStream) {
            this.dtdInputStream = dtdInputStream;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource source = null;
            try {
                File file = null;
                if (systemId != null && !systemId.isEmpty()) {
                    file = new File(systemId);
                } else if (publicId != null && !publicId.isEmpty()) {
                    file = new File(publicId);
                }
                if (file != null && file.exists()) {
                    source = new InputSource(new FileInputStream(file));
                }
                if (source == null) {
                    if (this.dtdInputStream != null) {
                        return new InputSource(this.dtdInputStream);
                    }
                    source = new InputSource(new ByteArrayInputStream(Xmls.NULL_XML_STR.getBytes()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return source;
        }
    }
}

