/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="expiretime")
class ExpireTime
extends AbstractRedisOperation {
    ExpireTime(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected int maxArgs() {
        return 1;
    }

    @Override
    protected int minArgs() {
        return 1;
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        if (!this.base().exists(key)) {
            return Response.integer(-2L);
        }
        Long deadline = this.base().getDeadline(this.params().get(0));
        if (deadline == null || deadline < 0L) {
            return Response.integer(-1L);
        }
        return Response.integer(deadline / 1000L);
    }
}

