/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.cache.impl.ClassFieldListCache;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class BeanUtil {
    private BeanUtil() {
    }

    public static Map<String, Object> beanToMap(Object bean) {
        ArgUtil.notNull(bean, "bean");
        try {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            List fieldList = (List)ClassFieldListCache.getInstance().get(bean.getClass());
            for (Field field : fieldList) {
                String fieldName = field.getName();
                Object fieldValue = field.get(bean);
                map.put(fieldName, fieldValue);
            }
            return map;
        }
        catch (IllegalAccessException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static void mapToBean(Map<String, Object> map, Object bean) {
        ArgUtil.notNull(bean, "bean");
        if (MapUtil.isEmpty(map)) {
            return;
        }
        try {
            List fieldList = (List)ClassFieldListCache.getInstance().get(bean.getClass());
            for (Field field : fieldList) {
                String fieldName = field.getName();
                Object fieldValue = map.get(fieldName);
                if (!ObjectUtil.isNotNull(fieldValue)) continue;
                field.set(bean, fieldValue);
            }
        }
        catch (IllegalAccessException e) {
            throw new CommonRuntimeException(e);
        }
    }
}

