/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class ClassGenericUtil {
    private ClassGenericUtil() {
    }

    private static List<Type> getGenericInterfaces(Class clazz) {
        Type superType;
        HashSet<Object> typeSet = new HashSet<Object>();
        Object[] types = clazz.getGenericInterfaces();
        if (ArrayUtil.isNotEmpty(types)) {
            typeSet.addAll(Guavas.newArrayList(types));
        }
        if (ObjectUtil.isNotNull(superType = clazz.getGenericSuperclass()) && superType.getClass().isInterface()) {
            typeSet.add(superType);
        }
        return Guavas.newArrayList(typeSet);
    }

    public static Class getGenericClass(Class clazz, Class interfaceClass, int index) {
        List<Type> typeList = ClassGenericUtil.getGenericInterfaces(clazz);
        for (Type type : typeList) {
            if (!(type instanceof ParameterizedType) || !interfaceClass.equals(((ParameterizedType)type).getRawType())) continue;
            ParameterizedType p = (ParameterizedType)type;
            return (Class)p.getActualTypeArguments()[index];
        }
        return Object.class;
    }

    public static Class getGenericClass(Collection<?> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        for (Object object : list) {
            if (!ObjectUtil.isNotNull(object)) continue;
            return object.getClass();
        }
        return null;
    }

    public static Class getGenericSupperClass(Class clazz, int index) {
        Class classType = Object.class;
        Type pageVoParserClass = clazz.getGenericSuperclass();
        if (pageVoParserClass instanceof ParameterizedType) {
            Type[] pageVoClassTypes = ((ParameterizedType)pageVoParserClass).getActualTypeArguments();
            classType = (Class)pageVoClassTypes[index];
        }
        return classType;
    }

    public static Class getGenericSupperClass(Class clazz) {
        return ClassGenericUtil.getGenericSupperClass(clazz, 0);
    }
}

