/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReflectAnnotationUtil {
    private ReflectAnnotationUtil() {
    }

    public static void updateValue(Annotation annotation, String method, Object value) {
        Map<String, Object> memberValues = ReflectAnnotationUtil.getAnnotationAttributes(annotation);
        memberValues.put(method, value);
    }

    public static Object getValue(Annotation annotation, String method) {
        Map<String, Object> memberValues = ReflectAnnotationUtil.getAnnotationAttributes(annotation);
        return memberValues.get(method);
    }

    public static String getValueStr(Annotation annotation, String method) {
        Map<String, Object> memberValues = ReflectAnnotationUtil.getAnnotationAttributes(annotation);
        Object object = memberValues.get(method);
        return ObjectUtil.objectToString(object);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation) {
        try {
            InvocationHandler h = Proxy.getInvocationHandler(annotation);
            Field hField = h.getClass().getDeclaredField("memberValues");
            hField.setAccessible(true);
            return (Map)hField.get(h);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<Annotation> getAnnotation(Annotation annotation, Class<? extends Annotation> annotationClass) {
        if (ObjectUtil.isNull(annotation) || ObjectUtil.isNull(annotationClass)) {
            return Optional.empty();
        }
        Annotation atAnnotation = annotation.annotationType().getAnnotation(annotationClass);
        if (ObjectUtil.isNotNull(atAnnotation)) {
            return Optional.of(atAnnotation);
        }
        return Optional.empty();
    }

    public static Optional<Annotation> getAnnotation(Class clazz, Class<? extends Annotation> annotationClass) {
        ArgUtil.notNull(clazz, "clazz");
        ArgUtil.notNull(annotationClass, "annotationClass");
        if (clazz.isAnnotationPresent(annotationClass)) {
            Annotation annotation = clazz.getAnnotation(annotationClass);
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    public static List<Annotation> getAnnotationRefs(Class clazz, Class<? extends Annotation> annotationClass) {
        ArgUtil.notNull(clazz, "clazz");
        ArgUtil.notNull(annotationClass, "annotationClass");
        Set<Object> annotationSet = Guavas.newHashSet();
        Object[] annotations = clazz.getAnnotations();
        if (ArrayUtil.isEmpty(annotations)) {
            return Guavas.newArrayList();
        }
        for (Object annotation : annotations) {
            if (annotation.annotationType().equals(annotationClass)) {
                annotationSet.add(annotation);
                continue;
            }
            if (!annotation.annotationType().isAnnotationPresent(annotationClass)) continue;
            annotationSet.add(annotation);
        }
        return Guavas.newArrayList(annotationSet);
    }
}

