/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.io.big;

import com.github.houbb.heaven.util.io.FileUtil;
import com.github.houbb.heaven.util.io.big.BigFileStringHandlerContext;
import com.github.houbb.heaven.util.io.big.IBigFileStringHandler;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.nio.file.LinkOption;

public class BigFileStringHandlerSegment
implements IBigFileStringHandler {
    private final int limitSize;

    public BigFileStringHandlerSegment(int limitSize) {
        this.limitSize = limitSize;
    }

    @Override
    public void handle(BigFileStringHandlerContext context) {
        int index = context.getIndex();
        String line = context.getLine();
        int fileIndex = index / this.limitSize;
        String suffix = StringUtil.leftPadding(fileIndex + "", 3, '0');
        String targetFilePath = context.getFilePath() + "_" + suffix;
        if (FileUtil.notExists(targetFilePath, new LinkOption[0])) {
            FileUtil.createFile(targetFilePath);
        }
        FileUtil.append(targetFilePath, line);
    }
}

