/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.support.data;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.pinyin.spi.IPinyinData;
import java.util.Arrays;
import java.util.List;

@ThreadSafe
public class PinyinData
implements IPinyinData {
    private static final List<String> ZERO_SHENG_MU_LIST = Arrays.asList("a", "ai", "an", "ang", "ao", "e", "\u00ea", "ei", "en", "eng", "er", "o", "ou");
    private static final List<String> DOUBLE_SHENG_MU_LIST = Arrays.asList("zh", "ch", "sh");

    @Override
    public String shengMu(String pinyinNormal) {
        if (this.isZeroShengMu(pinyinNormal)) {
            return "";
        }
        String prefixDouble = pinyinNormal.substring(0, 2);
        if (DOUBLE_SHENG_MU_LIST.contains(prefixDouble)) {
            return prefixDouble;
        }
        return pinyinNormal.substring(0, 1);
    }

    @Override
    public String yunMu(String pinyinNormal) {
        String shengMu = this.shengMu(pinyinNormal);
        return pinyinNormal.substring(shengMu.length());
    }

    @Override
    public boolean isZeroShengMu(String pinyinNormal) {
        return ZERO_SHENG_MU_LIST.contains(pinyinNormal);
    }
}

