/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.support.tone;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.pinyin.spi.IPinyinToneReverse;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import com.github.houbb.pinyin.support.style.PinyinToneStyles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class PinyinToneReverse
implements IPinyinToneReverse {
    private static final Map<String, List<String>> CHAR_MAP;

    @Override
    public List<String> getHanziList(String pinyinLast) {
        return CHAR_MAP.get(pinyinLast);
    }

    static {
        List lines = StreamUtil.readAllLines((String)"/pinyin_dict_char.txt");
        List defineLines = StreamUtil.readAllLines((String)"/pinyin_dict_char_define.txt");
        lines.addAll(defineLines);
        CHAR_MAP = Guavas.newHashMap((int)lines.size());
        IPinyinToneStyle pinyinToneStyle = PinyinToneStyles.numLast();
        for (String line : lines) {
            String[] strings = line.split(":");
            List pinyinList = StringUtil.splitToList((String)strings[1]);
            String hanzi = strings[0];
            for (String pinyin : pinyinList) {
                String pinyinNumLast = pinyinToneStyle.style(pinyin);
                List<String> hanziList = CHAR_MAP.get(pinyinNumLast);
                if (hanziList == null) {
                    hanziList = new ArrayList<String>();
                }
                hanziList.add(hanzi);
                CHAR_MAP.put(pinyinNumLast, hanziList);
            }
        }
    }
}

