/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.sensitive.word.api.ISensitiveWordCharIgnore;
import com.github.houbb.sensitive.word.api.IWordCheck;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordData;
import com.github.houbb.sensitive.word.api.context.InnerSensitiveWordContext;
import com.github.houbb.sensitive.word.constant.enums.WordContainsTypeEnum;
import com.github.houbb.sensitive.word.constant.enums.WordTypeEnum;
import com.github.houbb.sensitive.word.constant.enums.WordValidModeEnum;
import com.github.houbb.sensitive.word.support.check.AbstractWordCheck;
import java.util.Map;

@ThreadSafe
public class WordCheckWordAllow
extends AbstractWordCheck {
    private static final IWordCheck INSTANCE = new WordCheckWordAllow();

    public static IWordCheck getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<? extends IWordCheck> getSensitiveCheckClass() {
        return WordCheckWordAllow.class;
    }

    @Override
    protected int getActualLength(int beginIndex, InnerSensitiveWordContext innerContext) {
        String txt = innerContext.originalText();
        Map<Character, Character> formatCharMapping = innerContext.formatCharMapping();
        WordValidModeEnum wordValidModeEnum = innerContext.modeEnum();
        IWordContext context = innerContext.wordContext();
        int actualLength = 0;
        IWordData wordDataAllow = context.wordDataAllow();
        StringBuilder stringBuilder = new StringBuilder();
        char[] rawChars = txt.toCharArray();
        ISensitiveWordCharIgnore wordCharIgnore = context.charIgnore();
        int tempLen = 0;
        for (int i = beginIndex; i < rawChars.length; ++i) {
            if (wordCharIgnore.ignore(i, rawChars, innerContext) && tempLen != 0) {
                ++tempLen;
                continue;
            }
            char currentChar = rawChars[i];
            char mappingChar = formatCharMapping.get(Character.valueOf(currentChar)).charValue();
            stringBuilder.append(mappingChar);
            ++tempLen;
            WordContainsTypeEnum wordContainsTypeEnum = wordDataAllow.contains(stringBuilder, innerContext);
            if (WordContainsTypeEnum.CONTAINS_END.equals((Object)wordContainsTypeEnum)) {
                actualLength = tempLen;
                if (WordValidModeEnum.FAIL_FAST.equals((Object)wordValidModeEnum)) break;
            }
            if (WordContainsTypeEnum.NOT_FOUND.equals((Object)wordContainsTypeEnum)) break;
        }
        return actualLength;
    }

    @Override
    protected String getType() {
        return WordTypeEnum.WORD.getCode();
    }
}

