/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.tag;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.io.FileUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.support.tag.AbstractWordTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileWordTag
extends AbstractWordTag {
    protected final String filePath;
    protected final String wordSplit;
    protected final String tagSplit;
    protected Map<String, Set<String>> wordTagMap = new HashMap<String, Set<String>>();

    public FileWordTag(String filePath) {
        this(filePath, " ", ",");
    }

    public FileWordTag(String filePath, String wordSplit, String tagSplit) {
        ArgUtil.notEmpty((String)filePath, (String)"filePath");
        ArgUtil.notEmpty((String)wordSplit, (String)"wordSplit");
        ArgUtil.notEmpty((String)tagSplit, (String)"tagSplit");
        this.wordSplit = wordSplit;
        this.tagSplit = tagSplit;
        this.filePath = filePath;
        this.initWordTagMap();
    }

    protected synchronized void initWordTagMap() {
        List lines = FileUtil.readAllLines((String)this.filePath);
        if (CollectionUtil.isEmpty((Collection)lines)) {
            return;
        }
        for (String line : lines) {
            if (StringUtil.isEmpty((String)line)) continue;
            this.handleInitLine(line);
        }
    }

    protected synchronized void handleInitLine(String line) {
        String[] strings = line.split(this.wordSplit);
        if (strings.length < 2) {
            return;
        }
        String word = strings[0];
        String tagText = strings[1];
        String[] tags = tagText.split(this.tagSplit);
        HashSet<String> tagSet = new HashSet<String>(Arrays.asList(tags));
        this.wordTagMap.put(word, tagSet);
    }

    @Override
    protected Set<String> doGetTag(String word) {
        return this.wordTagMap.get(word);
    }
}

