/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc;

import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.log.Logger;
import com.github.housepower.jdbc.log.LoggerFactory;
import com.github.housepower.jdbc.wrapper.SQLArray;
import java.sql.SQLException;
import java.util.StringJoiner;

public class ClickHouseArray
implements SQLArray {
    private static final Logger LOG = LoggerFactory.getLogger(ClickHouseArray.class);
    private final IDataType itemDataType;
    private final Object[] data;

    public ClickHouseArray(IDataType itemDataType, Object[] data) {
        this.itemDataType = itemDataType;
        this.data = data;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.itemDataType.name();
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.itemDataType.sqlTypeId();
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Object getArray() throws SQLException {
        return this.data;
    }

    @Override
    public Logger logger() {
        return LOG;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        for (Object item : this.data) {
            joiner.add(String.valueOf(item));
        }
        return joiner.toString();
    }

    public ClickHouseArray slice(int offset, int length) {
        Object[] result = new Object[length];
        if (length >= 0) {
            System.arraycopy(this.data, offset, result, 0, length);
        }
        return new ClickHouseArray(this.itemDataType, result);
    }
}

