/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type.complex;

import com.github.housepower.jdbc.ClickHouseArray;
import com.github.housepower.jdbc.data.DataTypeFactory;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.data.type.complex.DataTypeCreator;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serde.BinaryDeserializer;
import com.github.housepower.jdbc.serde.BinarySerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;

public class DataTypeArray
implements IDataType {
    public static DataTypeCreator creator = (lexer, serverContext) -> {
        Validate.isTrue(lexer.character() == '(');
        IDataType arrayNestedType = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.character() == ')');
        return new DataTypeArray("Array(" + arrayNestedType.name() + ")", arrayNestedType, DataTypeFactory.get("UInt64", serverContext));
    };
    private final String name;
    private final Array defaultValue;
    private final IDataType elemDataType;
    private final IDataType offsetIDataType;

    public IDataType getElemDataType() {
        return this.elemDataType;
    }

    public DataTypeArray(String name, IDataType elemDataType, IDataType offsetIDataType) throws SQLException {
        this.name = name;
        this.elemDataType = elemDataType;
        this.offsetIDataType = offsetIDataType;
        this.defaultValue = new ClickHouseArray(elemDataType, new Object[]{elemDataType.defaultValue()});
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 2003;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class javaType() {
        return Array.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        Validate.isTrue(lexer.character() == '[');
        ArrayList<Object> arrayData = new ArrayList<Object>();
        while (true) {
            if (lexer.isCharacter(']')) break;
            if (lexer.isCharacter(',')) {
                lexer.character();
            }
            arrayData.add(this.elemDataType.deserializeTextQuoted(lexer));
        }
        lexer.character();
        return new ClickHouseArray(this.elemDataType, arrayData.toArray());
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        Object[] arr;
        for (Object f : arr = (Object[])data) {
            this.getElemDataType().serializeBinary(f, serializer);
        }
    }

    @Override
    public void serializeBinaryBulk(Object[] data, BinarySerializer serializer) throws SQLException, IOException {
        this.offsetIDataType.serializeBinary(data.length, serializer);
        this.getElemDataType().serializeBinaryBulk(data, serializer);
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        Long offset = (Long)this.offsetIDataType.deserializeBinary(deserializer);
        return this.elemDataType.deserializeBinaryBulk(offset.intValue(), deserializer);
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws IOException, SQLException {
        Object[] data = new ClickHouseArray[rows];
        if (rows == 0) {
            return data;
        }
        Object[] offsets = this.offsetIDataType.deserializeBinaryBulk(rows, deserializer);
        ClickHouseArray res = new ClickHouseArray(this.elemDataType, this.elemDataType.deserializeBinaryBulk(((BigInteger)offsets[rows - 1]).intValue(), deserializer));
        int lastOffset = 0;
        for (int row = 0; row < rows; ++row) {
            BigInteger offset = (BigInteger)offsets[row];
            data[row] = res.slice(lastOffset, offset.intValue() - lastOffset);
            lastOffset = offset.intValue();
        }
        return data;
    }
}

