/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.stream;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.stream.InputFormat;
import java.sql.SQLException;
import java.util.BitSet;

public class ValuesWithParametersInputFormat
implements InputFormat {
    private final SQLLexer lexer;

    public ValuesWithParametersInputFormat(int pos, String sql) {
        this.lexer = new SQLLexer(pos, sql);
    }

    @Override
    public void fillBlock(Block block) throws SQLException {
        int columnIdx;
        BitSet constIdxFlags = new BitSet(block.columnCnt());
        char nextChar = this.lexer.character();
        Validate.isTrue(nextChar == '(');
        for (columnIdx = 0; columnIdx < block.columnCnt(); ++columnIdx) {
            if (columnIdx > 0) {
                Validate.isTrue(this.lexer.character() == ',');
            }
            if (this.lexer.isCharacter('?')) {
                this.lexer.character();
                continue;
            }
            constIdxFlags.set(columnIdx);
            block.setConstObject(columnIdx, block.getColumnByPosition(columnIdx).type().deserializeTextQuoted(this.lexer));
        }
        for (columnIdx = 0; columnIdx < block.columnCnt(); ++columnIdx) {
            if (!constIdxFlags.get(columnIdx)) continue;
            block.incPlaceholderIndexes(columnIdx);
        }
        Validate.isTrue(this.lexer.character() == ')');
    }
}

