/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarlakxen.embedphantomjs.executor;

import com.github.jarlakxen.embedphantomjs.PhantomJSReference;
import com.github.jarlakxen.embedphantomjs.exception.UnexpectedProcessEndException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PhantomJSConsoleExecutor {
    private static final Logger LOGGER = Logger.getLogger(PhantomJSConsoleExecutor.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;
    private static final char[] SYSTEM_NEWLINE = System.getProperty("line.separator").toCharArray();
    private static final String DEFAULT_PHANTOMJS_CONSOLE_PREFIX = "phantomjs> ";
    private static final List<String> DEFAULT_PHANTOMJS_CONSOLE_POSTFIXS = Arrays.asList("{}", "undefined");
    private static final String PHANTOMJS_PARSER_ERROR_PREFIX = "Parse error";
    private ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
    private PhantomJSReference phantomReference;
    private File scriptFile;
    private String[] scriptArgs;
    private String consolePrefix;
    private List<String> consolePostfix = Collections.emptyList();
    private Process process;

    public PhantomJSConsoleExecutor(PhantomJSReference phantomReference) {
        this.phantomReference = phantomReference;
        this.consolePrefix = DEFAULT_PHANTOMJS_CONSOLE_PREFIX;
        this.consolePostfix = DEFAULT_PHANTOMJS_CONSOLE_POSTFIXS;
    }

    public PhantomJSConsoleExecutor(PhantomJSReference phantomReference, File scriptFile, String ... scriptArgs) {
        this.phantomReference = phantomReference;
        this.scriptFile = scriptFile;
        this.scriptArgs = scriptArgs;
    }

    public int getPid() {
        if (this.process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = this.process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return f.getInt(this.process);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean isAlive() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException ex) {
            return true;
        }
    }

    public void start() {
        try {
            String cmd = this.phantomReference.getBinaryPath();
            if (this.scriptFile != null) {
                cmd = cmd + " " + this.scriptFile.getAbsolutePath();
            }
            if (this.scriptArgs != null && this.scriptArgs.length > 0) {
                cmd = cmd + " " + StringUtils.join((Object[])this.scriptArgs, (String)" ");
            }
            this.process = Runtime.getRuntime().exec(cmd);
            if (StringUtils.isNotBlank((CharSequence)this.consolePrefix)) {
                this.process.getInputStream().read(new byte[this.consolePrefix.length()]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int destroy() {
        try {
            this.process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isAlive()) {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.process.exitValue();
    }

    public ListenableFuture<String> execute(String scriptSource) throws UnexpectedProcessEndException {
        return this.execute(IOUtils.toInputStream((String)scriptSource, (Charset)Charset.defaultCharset()), this.consolePostfix);
    }

    public ListenableFuture<String> execute(String scriptSource, String ... endLines) throws UnexpectedProcessEndException {
        return this.execute(IOUtils.toInputStream((String)scriptSource, (Charset)Charset.defaultCharset()), Arrays.asList(endLines));
    }

    public ListenableFuture<String> execute(InputStream scriptSourceInputStream, String ... endLines) throws UnexpectedProcessEndException {
        return this.execute(scriptSourceInputStream, Arrays.asList(endLines));
    }

    public ListenableFuture<String> execute(final InputStream scriptSourceInputStream, final List<String> endLines) throws UnexpectedProcessEndException {
        return this.executorService.submit((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return PhantomJSConsoleExecutor.this.doExecute(scriptSourceInputStream, endLines);
            }
        });
    }

    private String doExecute(InputStream scriptSourceInputStream, List<String> endLines) throws UnexpectedProcessEndException {
        if (!this.isAlive()) {
            throw new UnexpectedProcessEndException();
        }
        try {
            String input = this.copy(scriptSourceInputStream, this.process.getOutputStream());
            if (!this.endWithNewLine(input)) {
                for (char c : SYSTEM_NEWLINE) {
                    this.process.getOutputStream().write(c);
                }
            }
            this.process.getOutputStream().flush();
            String output = this.readPhantomJSOutput(this.process.getInputStream(), endLines);
            LOGGER.debug((Object)("Program output: " + output));
            return output;
        }
        catch (IOException e) {
            throw new UnexpectedProcessEndException(e);
        }
    }

    private String readPhantomJSOutput(InputStream processInput, List<String> endLines) throws IOException {
        StringBuilder out = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(processInput, "UTF-8"));
        while (true) {
            String line = in.readLine();
            LOGGER.trace((Object)("Incoming line from process: " + line));
            if (line.equals(PHANTOMJS_PARSER_ERROR_PREFIX)) {
                return line;
            }
            if (line == null || endLines.contains(line)) {
                if (!StringUtils.isNotBlank((CharSequence)this.consolePrefix)) break;
                in.skip(this.consolePrefix.length());
                break;
            }
            if (out.length() > 0) {
                out.append("\n");
            }
            out.append(line);
        }
        return out.toString();
    }

    private boolean endWithNewLine(String input) {
        return input.endsWith(String.valueOf(SYSTEM_NEWLINE));
    }

    private String copy(InputStream input, OutputStream output) throws IOException {
        StringBuilder inputString = new StringBuilder();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            inputString.append(new String(buffer, 0, n));
        }
        return inputString.toString();
    }

    public void setConsolePrefix(String consolePrefix) {
        this.consolePrefix = consolePrefix;
    }

    public String getConsolePrefix() {
        return this.consolePrefix;
    }

    public void setConsolePostfix(List<String> consolePostfix) {
        this.consolePostfix = consolePostfix;
    }

    public List<String> getConsolePostfix() {
        return this.consolePostfix;
    }
}

