/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarlakxen.embedphantomjs.executor;

import com.github.jarlakxen.embedphantomjs.ExecutionTimeout;
import com.github.jarlakxen.embedphantomjs.PhantomJSReference;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PhantomJSFileExecutor {
    private static final Logger LOGGER = Logger.getLogger(PhantomJSFileExecutor.class);
    private ListeningExecutorService processExecutorService;
    private ExecutorService timeoutExecutorService;
    private PhantomJSReference phantomReference;
    private ExecutionTimeout executionTimeout;

    public PhantomJSFileExecutor(PhantomJSReference phantomReference, ExecutionTimeout executionTimeout) {
        this(phantomReference, Executors.newCachedThreadPool(), executionTimeout);
    }

    public PhantomJSFileExecutor(PhantomJSReference phantomReference, ExecutorService executorService, ExecutionTimeout executionTimeout) {
        this.phantomReference = phantomReference;
        this.executionTimeout = executionTimeout;
        this.processExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        this.timeoutExecutorService = Executors.newCachedThreadPool();
    }

    public ListenableFuture<String> execute(String fileContent, String ... args) {
        try {
            final File tmp = File.createTempFile(RandomStringUtils.randomAlphabetic((int)10), ".js");
            FileUtils.write((File)tmp, (CharSequence)fileContent, (Charset)Charset.defaultCharset());
            ListenableFuture<String> result = this.execute(tmp, args);
            Futures.addCallback(result, (FutureCallback)new FutureCallback<String>(){

                public void onSuccess(String explosion) {
                    this.onComplete();
                }

                public void onFailure(Throwable thrown) {
                    LOGGER.error((Object)"", thrown);
                    this.onComplete();
                }

                public void onComplete() {
                    if (tmp != null) {
                        tmp.delete();
                    }
                }
            });
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ListenableFuture<String> execute(File sourceFile, String ... args) {
        final String cmd = this.phantomReference.getBinaryPath() + " " + this.phantomReference.getCommandLineOptions() + " " + sourceFile.getAbsolutePath() + " " + StringUtils.join((Object[])args, (String)" ");
        try {
            final Process process = Runtime.getRuntime().exec(cmd);
            LOGGER.info((Object)("Command to execute: " + cmd));
            final ListenableFuture action = this.processExecutorService.submit((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    LOGGER.info((Object)("Command to execute: " + cmd));
                    String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
                    process.waitFor();
                    LOGGER.debug((Object)("Command " + cmd + " output:" + output));
                    return output;
                }
            });
            this.timeoutExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        action.get(PhantomJSFileExecutor.this.executionTimeout.getTimeout(), PhantomJSFileExecutor.this.executionTimeout.getUnit());
                    }
                    catch (Exception e) {
                        action.cancel(false);
                        process.destroy();
                    }
                }
            });
            return action;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

