/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.TokenTypes;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import com.github.javaparser.printer.concretesyntaxmodel.CsmIndent;
import com.github.javaparser.printer.concretesyntaxmodel.CsmMix;
import com.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import com.github.javaparser.printer.concretesyntaxmodel.CsmUnindent;
import com.github.javaparser.printer.lexicalpreservation.ChildTextElement;
import com.github.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.github.javaparser.printer.lexicalpreservation.NodeText;
import com.github.javaparser.printer.lexicalpreservation.TextElement;
import com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Difference {
    private static final int STANDARD_INDENTATION_SIZE = 4;
    private final List<DifferenceElement> elements;

    private Difference(List<DifferenceElement> elements) {
        this.elements = elements;
    }

    private static boolean matching(CsmElement a, CsmElement b) {
        if (a instanceof LexicalDifferenceCalculator.CsmChild) {
            if (b instanceof LexicalDifferenceCalculator.CsmChild) {
                LexicalDifferenceCalculator.CsmChild childA = (LexicalDifferenceCalculator.CsmChild)a;
                LexicalDifferenceCalculator.CsmChild childB = (LexicalDifferenceCalculator.CsmChild)b;
                return childA.getChild().equals(childB.getChild());
            }
            if (b instanceof CsmToken) {
                return false;
            }
            if (b instanceof CsmIndent) {
                return false;
            }
            if (b instanceof CsmUnindent) {
                return false;
            }
            throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
        }
        if (a instanceof CsmToken) {
            if (b instanceof CsmToken) {
                CsmToken childA = (CsmToken)a;
                CsmToken childB = (CsmToken)b;
                return childA.getTokenType() == childB.getTokenType();
            }
            if (b instanceof LexicalDifferenceCalculator.CsmChild) {
                return false;
            }
            if (b instanceof CsmIndent) {
                return false;
            }
            if (b instanceof CsmUnindent) {
                return false;
            }
            throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
        }
        if (a instanceof CsmIndent) {
            return b instanceof CsmIndent;
        }
        if (a instanceof CsmUnindent) {
            return b instanceof CsmUnindent;
        }
        throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
    }

    private static boolean replacement(CsmElement a, CsmElement b) {
        if (a instanceof CsmIndent || b instanceof CsmIndent || a instanceof CsmUnindent || b instanceof CsmUnindent) {
            return false;
        }
        if (a instanceof LexicalDifferenceCalculator.CsmChild) {
            if (b instanceof LexicalDifferenceCalculator.CsmChild) {
                LexicalDifferenceCalculator.CsmChild childA = (LexicalDifferenceCalculator.CsmChild)a;
                LexicalDifferenceCalculator.CsmChild childB = (LexicalDifferenceCalculator.CsmChild)b;
                return childA.getChild().getClass().equals(childB.getChild().getClass());
            }
            if (b instanceof CsmToken) {
                return false;
            }
            throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
        }
        if (a instanceof CsmToken) {
            if (b instanceof CsmToken) {
                CsmToken childA = (CsmToken)a;
                CsmToken childB = (CsmToken)b;
                return childA.getTokenType() == childB.getTokenType();
            }
            if (b instanceof LexicalDifferenceCalculator.CsmChild) {
                return false;
            }
        }
        throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
    }

    private static Map<Node, Integer> findChildrenPositions(LexicalDifferenceCalculator.CalculatedSyntaxModel calculatedSyntaxModel) {
        HashMap<Node, Integer> positions = new HashMap<Node, Integer>();
        for (int i = 0; i < calculatedSyntaxModel.elements.size(); ++i) {
            CsmElement element = calculatedSyntaxModel.elements.get(i);
            if (!(element instanceof LexicalDifferenceCalculator.CsmChild)) continue;
            positions.put(((LexicalDifferenceCalculator.CsmChild)element).getChild(), i);
        }
        return positions;
    }

    static Difference calculate(LexicalDifferenceCalculator.CalculatedSyntaxModel original, LexicalDifferenceCalculator.CalculatedSyntaxModel after) {
        Map<Node, Integer> childrenInOriginal = Difference.findChildrenPositions(original);
        Map<Node, Integer> childrenInAfter = Difference.findChildrenPositions(after);
        LinkedList<Node> commonChildren = new LinkedList<Node>(childrenInOriginal.keySet());
        commonChildren.retainAll(childrenInAfter.keySet());
        commonChildren.sort(Comparator.comparingInt(childrenInOriginal::get));
        LinkedList<DifferenceElement> elements = new LinkedList<DifferenceElement>();
        int originalIndex = 0;
        int afterIndex = 0;
        int commonChildrenIndex = 0;
        while (commonChildrenIndex < commonChildren.size()) {
            Node child = (Node)commonChildren.get(commonChildrenIndex++);
            int posOfNextChildInOriginal = childrenInOriginal.get(child);
            int posOfNextChildInAfter = childrenInAfter.get(child);
            if (originalIndex < posOfNextChildInOriginal || afterIndex < posOfNextChildInAfter) {
                elements.addAll(Difference.calculateImpl((LexicalDifferenceCalculator.CalculatedSyntaxModel)original.sub((int)originalIndex, (int)posOfNextChildInOriginal), (LexicalDifferenceCalculator.CalculatedSyntaxModel)after.sub((int)afterIndex, (int)posOfNextChildInAfter)).elements);
            }
            elements.add(new Kept(new LexicalDifferenceCalculator.CsmChild(child)));
            originalIndex = posOfNextChildInOriginal + 1;
            afterIndex = posOfNextChildInAfter + 1;
        }
        if (originalIndex < original.elements.size() || afterIndex < after.elements.size()) {
            elements.addAll(Difference.calculateImpl((LexicalDifferenceCalculator.CalculatedSyntaxModel)original.sub((int)originalIndex, (int)original.elements.size()), (LexicalDifferenceCalculator.CalculatedSyntaxModel)after.sub((int)afterIndex, (int)after.elements.size())).elements);
        }
        return new Difference(elements);
    }

    private static Difference calculateImpl(LexicalDifferenceCalculator.CalculatedSyntaxModel original, LexicalDifferenceCalculator.CalculatedSyntaxModel after) {
        LinkedList<DifferenceElement> elements = new LinkedList<DifferenceElement>();
        int originalIndex = 0;
        int afterIndex = 0;
        do {
            if (originalIndex < original.elements.size() && afterIndex >= after.elements.size()) {
                elements.add(new Removed(original.elements.get(originalIndex)));
                ++originalIndex;
                continue;
            }
            if (originalIndex >= original.elements.size() && afterIndex < after.elements.size()) {
                elements.add(new Added(after.elements.get(afterIndex)));
                ++afterIndex;
                continue;
            }
            CsmElement nextOriginal = original.elements.get(originalIndex);
            CsmElement nextAfter = after.elements.get(afterIndex);
            if (nextOriginal instanceof CsmMix && nextAfter instanceof CsmMix) {
                if (((CsmMix)nextAfter).getElements().equals(((CsmMix)nextOriginal).getElements())) {
                    ((CsmMix)nextAfter).getElements().forEach(el -> elements.add(new Kept((CsmElement)el)));
                } else {
                    elements.add(new Reshuffled((CsmMix)nextOriginal, (CsmMix)nextAfter));
                }
                ++originalIndex;
                ++afterIndex;
                continue;
            }
            if (Difference.matching(nextOriginal, nextAfter)) {
                elements.add(new Kept(nextOriginal));
                ++originalIndex;
                ++afterIndex;
                continue;
            }
            if (Difference.replacement(nextOriginal, nextAfter)) {
                elements.add(new Removed(nextOriginal));
                elements.add(new Added(nextAfter));
                ++originalIndex;
                ++afterIndex;
                continue;
            }
            Difference adding = Difference.calculate(original.from(originalIndex), after.from(afterIndex + 1));
            Difference removing = null;
            if (adding.cost() > 0L) {
                removing = Difference.calculate(original.from(originalIndex + 1), after.from(afterIndex));
            }
            if (removing == null || super.cost() > adding.cost()) {
                elements.add(new Added(nextAfter));
                ++afterIndex;
                continue;
            }
            elements.add(new Removed(nextOriginal));
            ++originalIndex;
        } while (originalIndex < original.elements.size() || afterIndex < after.elements.size());
        return new Difference(elements);
    }

    private TextElement toTextElement(CsmElement csmElement) {
        if (csmElement instanceof LexicalDifferenceCalculator.CsmChild) {
            return new ChildTextElement(((LexicalDifferenceCalculator.CsmChild)csmElement).getChild());
        }
        if (csmElement instanceof CsmToken) {
            return new TokenTextElement(((CsmToken)csmElement).getTokenType(), ((CsmToken)csmElement).getContent(null));
        }
        throw new UnsupportedOperationException(csmElement.getClass().getSimpleName());
    }

    private List<TextElement> processIndentation(List<TokenTextElement> indentation, List<TextElement> prevElements) {
        LinkedList<TextElement> res = new LinkedList<TextElement>();
        res.addAll(indentation);
        boolean afterNl = false;
        for (TextElement e : prevElements) {
            if (e.isNewline() || e.isToken(5)) {
                res.clear();
                afterNl = true;
                continue;
            }
            if (afterNl && e instanceof TokenTextElement && TokenTypes.isWhitespace(((TokenTextElement)e).getTokenKind())) {
                res.add(e);
                continue;
            }
            afterNl = false;
        }
        return res;
    }

    private List<TextElement> indentationBlock() {
        LinkedList<TextElement> res = new LinkedList<TextElement>();
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        return res;
    }

    private int considerCleaningTheLine(NodeText nodeText, int nodeTextIndex) {
        while (nodeTextIndex >= 1 && nodeText.getElements().get(nodeTextIndex - 1).isWhiteSpace() && !nodeText.getElements().get(nodeTextIndex - 1).isNewline()) {
            nodeText.removeElement(nodeTextIndex - 1);
            --nodeTextIndex;
        }
        return nodeTextIndex;
    }

    private boolean isAfterLBrace(NodeText nodeText, int nodeTextIndex) {
        if (nodeTextIndex > 0 && nodeText.getElements().get(nodeTextIndex - 1).isToken(93)) {
            return true;
        }
        if (nodeTextIndex > 0 && nodeText.getElements().get(nodeTextIndex - 1).isWhiteSpace() && !nodeText.getElements().get(nodeTextIndex - 1).isNewline()) {
            return this.isAfterLBrace(nodeText, nodeTextIndex - 1);
        }
        return false;
    }

    private int considerEnforcingIndentation(NodeText nodeText, int nodeTextIndex) {
        int i;
        boolean hasOnlyWsBefore = true;
        for (i = nodeTextIndex; i >= 0 && hasOnlyWsBefore && i < nodeText.getElements().size() && !nodeText.getElements().get(i).isNewline(); --i) {
            if (nodeText.getElements().get(i).isSpaceOrTab()) continue;
            hasOnlyWsBefore = false;
        }
        if (hasOnlyWsBefore) {
            for (i = nodeTextIndex; i >= 0 && i < nodeText.getElements().size() && !nodeText.getElements().get(i).isNewline(); --i) {
                nodeText.removeElement(i);
            }
        }
        return nodeTextIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void apply(NodeText nodeText, Node node) {
        if (nodeText == null) {
            throw new NullPointerException();
        }
        boolean addedIndentation = false;
        List<TokenTextElement> indentation = LexicalPreservingPrinter.findIndentation(node);
        int diffIndex = 0;
        int nodeTextIndex = 0;
        do {
            DifferenceElement diffEl;
            if (diffIndex < this.elements.size() && nodeTextIndex >= nodeText.getElements().size()) {
                diffEl = this.elements.get(diffIndex);
                if (diffEl instanceof Kept) {
                    Kept kept = (Kept)diffEl;
                    if (!(kept.element instanceof CsmToken)) throw new IllegalStateException("Cannot keep element because we reached the end of nodetext: " + nodeText + ". Difference: " + this);
                    CsmToken csmToken = (CsmToken)kept.element;
                    if (!TokenTypes.isWhitespaceOrComment(csmToken.getTokenType())) throw new IllegalStateException("Cannot keep element because we reached the end of nodetext: " + nodeText + ". Difference: " + this);
                    ++diffIndex;
                    continue;
                }
                if (!(diffEl instanceof Added)) throw new UnsupportedOperationException(diffEl.getClass().getSimpleName());
                nodeText.addElement(nodeTextIndex, this.toTextElement(((Added)diffEl).element));
                ++nodeTextIndex;
                ++diffIndex;
                continue;
            }
            if (diffIndex >= this.elements.size() && nodeTextIndex < nodeText.getElements().size()) {
                TextElement nodeTextEl = nodeText.getElements().get(nodeTextIndex);
                if (!nodeTextEl.isWhiteSpaceOrComment()) throw new UnsupportedOperationException("NodeText: " + nodeText + ". Difference: " + this + " " + nodeTextEl);
                ++nodeTextIndex;
                continue;
            }
            diffEl = this.elements.get(diffIndex);
            TextElement nodeTextEl = nodeText.getElements().get(nodeTextIndex);
            if (diffEl instanceof Added) {
                CsmElement addedElement = ((Added)diffEl).element;
                if (addedElement instanceof CsmIndent) {
                    for (int i = 0; i < 4; ++i) {
                        indentation.add(new TokenTextElement(1));
                    }
                    addedIndentation = true;
                    ++diffIndex;
                    continue;
                }
                if (addedElement instanceof CsmUnindent) {
                    for (int i = 0; i < 4 && !indentation.isEmpty(); ++i) {
                        indentation.remove(indentation.size() - 1);
                    }
                    addedIndentation = false;
                    ++diffIndex;
                    continue;
                }
                TextElement textElement = this.toTextElement(addedElement);
                boolean used = false;
                if (nodeTextIndex > 0 && nodeText.getElements().get(nodeTextIndex - 1).isNewline()) {
                    for (TextElement e : this.processIndentation(indentation, nodeText.getElements().subList(0, nodeTextIndex - 1))) {
                        nodeText.addElement(nodeTextIndex++, e);
                    }
                } else if (this.isAfterLBrace(nodeText, nodeTextIndex) && !this.isAReplacement(diffIndex)) {
                    if (textElement.isNewline()) {
                        used = true;
                    }
                    nodeText.addElement(nodeTextIndex++, new TokenTextElement(TokenTypes.eolTokenKind()));
                    while (nodeText.getElements().get(nodeTextIndex).isSpaceOrTab()) {
                        nodeText.getElements().remove(nodeTextIndex);
                    }
                    for (TextElement e : this.processIndentation(indentation, nodeText.getElements().subList(0, nodeTextIndex - 1))) {
                        nodeText.addElement(nodeTextIndex++, e);
                    }
                    if (!addedIndentation) {
                        for (TextElement e : this.indentationBlock()) {
                            nodeText.addElement(nodeTextIndex++, e);
                        }
                    }
                }
                if (!used) {
                    nodeText.addElement(nodeTextIndex, textElement);
                    ++nodeTextIndex;
                }
                if (textElement.isNewline()) {
                    boolean followedByUnindent = diffIndex + 1 < this.elements.size() && this.elements.get(diffIndex + 1).isAdded() && this.elements.get(diffIndex + 1).getElement() instanceof CsmUnindent;
                    nodeTextIndex = this.adjustIndentation(indentation, nodeText, nodeTextIndex, followedByUnindent);
                }
                ++diffIndex;
                continue;
            }
            if (diffEl instanceof Kept) {
                Kept kept = (Kept)diffEl;
                if (kept.element instanceof LexicalDifferenceCalculator.CsmChild && nodeTextEl.isComment()) {
                    ++nodeTextIndex;
                    continue;
                }
                if (kept.element instanceof LexicalDifferenceCalculator.CsmChild && nodeTextEl instanceof ChildTextElement) {
                    ++diffIndex;
                    ++nodeTextIndex;
                    continue;
                }
                if (kept.element instanceof LexicalDifferenceCalculator.CsmChild && nodeTextEl instanceof TokenTextElement) {
                    if (nodeTextEl.isWhiteSpaceOrComment()) {
                        ++nodeTextIndex;
                        continue;
                    }
                    if (!(kept.element instanceof LexicalDifferenceCalculator.CsmChild)) throw new UnsupportedOperationException("kept " + kept.element + " vs " + nodeTextEl);
                    LexicalDifferenceCalculator.CsmChild keptChild = (LexicalDifferenceCalculator.CsmChild)kept.element;
                    if (!(keptChild.getChild() instanceof PrimitiveType)) throw new UnsupportedOperationException("kept " + kept.element + " vs " + nodeTextEl);
                    ++nodeTextIndex;
                    ++diffIndex;
                    continue;
                }
                if (kept.element instanceof CsmToken && nodeTextEl instanceof TokenTextElement) {
                    CsmToken csmToken = (CsmToken)kept.element;
                    TokenTextElement nodeTextToken = (TokenTextElement)nodeTextEl;
                    if (csmToken.getTokenType() == nodeTextToken.getTokenKind()) {
                        ++nodeTextIndex;
                        ++diffIndex;
                        continue;
                    }
                    if (TokenTypes.isWhitespaceOrComment(csmToken.getTokenType())) {
                        ++diffIndex;
                        continue;
                    }
                    if (!nodeTextToken.isWhiteSpaceOrComment()) throw new UnsupportedOperationException("Csm token " + csmToken + " NodeText TOKEN " + nodeTextToken);
                    ++nodeTextIndex;
                    continue;
                }
                if (kept.element instanceof CsmToken && ((CsmToken)kept.element).isWhiteSpace()) {
                    ++diffIndex;
                    continue;
                }
                if (kept.element instanceof CsmIndent) {
                    ++diffIndex;
                    continue;
                }
                if (!(kept.element instanceof CsmUnindent)) throw new UnsupportedOperationException("kept " + kept.element + " vs " + nodeTextEl);
                ++diffIndex;
                for (int i = 0; i < 4 && nodeTextIndex >= 1 && nodeText.getTextElement(nodeTextIndex - 1).isSpaceOrTab(); ++i) {
                    nodeText.removeElement(--nodeTextIndex);
                }
            } else {
                if (diffEl instanceof Removed) {
                    Removed removed = (Removed)diffEl;
                    if (removed.element instanceof LexicalDifferenceCalculator.CsmChild && nodeTextEl instanceof ChildTextElement) {
                        nodeText.removeElement(nodeTextIndex);
                        if (nodeTextIndex < nodeText.getElements().size() && nodeText.getElements().get(nodeTextIndex).isNewline()) {
                            nodeTextIndex = this.considerCleaningTheLine(nodeText, nodeTextIndex);
                        } else {
                            if (diffIndex + 1 >= this.getElements().size() || !(this.getElements().get(diffIndex + 1) instanceof Added)) {
                                nodeTextIndex = this.considerEnforcingIndentation(nodeText, nodeTextIndex);
                            }
                            if (nodeText.getElements().size() > nodeTextIndex && nodeTextIndex > 0 && nodeText.getElements().get(nodeTextIndex).isWhiteSpace() && nodeText.getElements().get(nodeTextIndex - 1).isWhiteSpace() && (diffIndex + 1 == this.elements.size() || this.elements.get(diffIndex + 1) instanceof Kept)) {
                                nodeText.getElements().remove(nodeTextIndex--);
                            }
                        }
                        ++diffIndex;
                        continue;
                    }
                    if (removed.element instanceof CsmToken && nodeTextEl instanceof TokenTextElement && ((CsmToken)removed.element).getTokenType() == ((TokenTextElement)nodeTextEl).getTokenKind()) {
                        nodeText.removeElement(nodeTextIndex);
                        ++diffIndex;
                        continue;
                    }
                    if (nodeTextEl instanceof TokenTextElement && nodeTextEl.isWhiteSpaceOrComment()) {
                        ++nodeTextIndex;
                        continue;
                    }
                    if (removed.element instanceof LexicalDifferenceCalculator.CsmChild && ((LexicalDifferenceCalculator.CsmChild)removed.element).getChild() instanceof PrimitiveType) {
                        if (!this.isPrimitiveType(nodeTextEl)) throw new UnsupportedOperationException("removed " + removed.element + " vs " + nodeTextEl);
                        nodeText.removeElement(nodeTextIndex);
                        ++diffIndex;
                        continue;
                    }
                    if (removed.element instanceof CsmToken && ((CsmToken)removed.element).isWhiteSpace()) {
                        ++diffIndex;
                        continue;
                    }
                    if (!nodeTextEl.isWhiteSpace()) throw new UnsupportedOperationException("removed " + removed.element + " vs " + nodeTextEl);
                    ++nodeTextIndex;
                    continue;
                }
                if (!(diffEl instanceof Reshuffled)) throw new UnsupportedOperationException("" + diffEl + " vs " + nodeTextEl);
                Reshuffled reshuffled = (Reshuffled)diffEl;
                CsmMix elementsFromPreviousOrder = reshuffled.previousOrder;
                CsmMix elementsFromNextOrder = reshuffled.element;
                HashMap<Integer, Integer> correspondanceBetweenNextOrderAndPreviousOrder = new HashMap<Integer, Integer>();
                for (int ni = 0; ni < elementsFromNextOrder.getElements().size(); ++ni) {
                    boolean found = false;
                    CsmElement ne = elementsFromNextOrder.getElements().get(ni);
                    for (int pi = 0; pi < elementsFromPreviousOrder.getElements().size() && !found; ++pi) {
                        CsmElement pe = elementsFromPreviousOrder.getElements().get(pi);
                        if (correspondanceBetweenNextOrderAndPreviousOrder.values().contains(pi) || !Difference.matching(ne, pe)) continue;
                        found = true;
                        correspondanceBetweenNextOrderAndPreviousOrder.put(ni, pi);
                    }
                }
                int startNodeTextIndex = nodeTextIndex;
                HashSet usedIndexes = new HashSet();
                List nodeTextIndexOfPreviousElements = elementsFromPreviousOrder.getElements().stream().map(it -> this.findIndexOfCorrespondingNodeTextElement((CsmElement)it, nodeText, startNodeTextIndex, usedIndexes, node)).collect(Collectors.toList());
                HashMap<Integer, Integer> nodeTextIndexToPreviousCSMIndex = new HashMap<Integer, Integer>();
                for (int i = 0; i < nodeTextIndexOfPreviousElements.size(); ++i) {
                    int value = (Integer)nodeTextIndexOfPreviousElements.get(i);
                    if (value == -1) continue;
                    nodeTextIndexToPreviousCSMIndex.put(value, i);
                }
                int lastNodeTextIndex = nodeTextIndexOfPreviousElements.stream().max(Integer::compareTo).orElse(-1);
                LinkedList<CsmElement> elementsToBeAddedAtTheEnd = new LinkedList<CsmElement>();
                HashMap elementsToAddBeforeGivenOriginalCSMElement = new HashMap();
                for (int ni = 0; ni < elementsFromNextOrder.getElements().size(); ++ni) {
                    if (correspondanceBetweenNextOrderAndPreviousOrder.containsKey(ni)) continue;
                    int originalCsmIndex = -1;
                    for (int nj = ni + 1; nj < elementsFromNextOrder.getElements().size() && originalCsmIndex == -1; ++nj) {
                        if (!correspondanceBetweenNextOrderAndPreviousOrder.containsKey(nj)) continue;
                        originalCsmIndex = (Integer)correspondanceBetweenNextOrderAndPreviousOrder.get(nj);
                        if (!elementsToAddBeforeGivenOriginalCSMElement.containsKey(originalCsmIndex)) {
                            elementsToAddBeforeGivenOriginalCSMElement.put(originalCsmIndex, new LinkedList());
                        }
                        ((List)elementsToAddBeforeGivenOriginalCSMElement.get(originalCsmIndex)).add(elementsFromNextOrder.getElements().get(ni));
                    }
                    if (originalCsmIndex != -1) continue;
                    elementsToBeAddedAtTheEnd.add(elementsFromNextOrder.getElements().get(ni));
                }
                this.getElements().remove(diffIndex);
                int diffElIterator = diffIndex;
                if (lastNodeTextIndex != -1) {
                    for (int ntIndex = startNodeTextIndex; ntIndex <= lastNodeTextIndex; ++ntIndex) {
                        if (!nodeTextIndexToPreviousCSMIndex.containsKey(ntIndex)) continue;
                        int indexOfOriginalCSMElement = (Integer)nodeTextIndexToPreviousCSMIndex.get(ntIndex);
                        if (elementsToAddBeforeGivenOriginalCSMElement.containsKey(indexOfOriginalCSMElement)) {
                            for (CsmElement elementToAdd : (List)elementsToAddBeforeGivenOriginalCSMElement.get(indexOfOriginalCSMElement)) {
                                this.elements.add(diffElIterator++, new Added(elementToAdd));
                            }
                        }
                        CsmElement originalCSMElement = elementsFromPreviousOrder.getElements().get(indexOfOriginalCSMElement);
                        boolean toBeKept = correspondanceBetweenNextOrderAndPreviousOrder.containsValue(indexOfOriginalCSMElement);
                        if (toBeKept) {
                            this.elements.add(diffElIterator++, new Kept(originalCSMElement));
                            continue;
                        }
                        this.elements.add(diffElIterator++, new Removed(originalCSMElement));
                    }
                }
                for (CsmElement elementToAdd : elementsToBeAddedAtTheEnd) {
                    this.elements.add(diffElIterator++, new Added(elementToAdd));
                }
            }
        } while (diffIndex < this.elements.size() || nodeTextIndex < nodeText.getElements().size());
    }

    private int findIndexOfCorrespondingNodeTextElement(CsmElement csmElement, NodeText nodeText, int startIndex, Set<Integer> usedIndexes, Node node) {
        for (int i = startIndex; i < nodeText.getElements().size(); ++i) {
            if (usedIndexes.contains(i)) continue;
            TextElement textElement = nodeText.getTextElement(i);
            if (csmElement instanceof CsmToken) {
                TokenTextElement tokenTextElement;
                CsmToken csmToken = (CsmToken)csmElement;
                if (!(textElement instanceof TokenTextElement) || (tokenTextElement = (TokenTextElement)textElement).getTokenKind() != csmToken.getTokenType() || !tokenTextElement.getText().equals(csmToken.getContent(node))) continue;
                usedIndexes.add(i);
                return i;
            }
            if (csmElement instanceof LexicalDifferenceCalculator.CsmChild) {
                ChildTextElement childTextElement;
                LexicalDifferenceCalculator.CsmChild csmChild = (LexicalDifferenceCalculator.CsmChild)csmElement;
                if (!(textElement instanceof ChildTextElement) || (childTextElement = (ChildTextElement)textElement).getChild() != csmChild.getChild()) continue;
                usedIndexes.add(i);
                return i;
            }
            throw new UnsupportedOperationException();
        }
        return -1;
    }

    private int adjustIndentation(List<TokenTextElement> indentation, NodeText nodeText, int nodeTextIndex, boolean followedByUnindent) {
        List<TextElement> indentationAdj = this.processIndentation(indentation, nodeText.getElements().subList(0, nodeTextIndex - 1));
        if (nodeTextIndex < nodeText.getElements().size() && nodeText.getElements().get(nodeTextIndex).isToken(94)) {
            indentationAdj = indentationAdj.subList(0, indentationAdj.size() - Math.min(4, indentationAdj.size()));
        } else if (followedByUnindent) {
            indentationAdj = indentationAdj.subList(0, Math.max(0, indentationAdj.size() - 4));
        }
        for (TextElement e : indentationAdj) {
            if (nodeTextIndex < nodeText.getElements().size() && nodeText.getElements().get(nodeTextIndex).isSpaceOrTab()) {
                ++nodeTextIndex;
                continue;
            }
            nodeText.getElements().add(nodeTextIndex++, e);
        }
        return nodeTextIndex;
    }

    private boolean isAReplacement(int diffIndex) {
        return diffIndex > 0 && this.getElements().get(diffIndex) instanceof Added && this.getElements().get(diffIndex - 1) instanceof Removed;
    }

    private boolean isPrimitiveType(TextElement textElement) {
        if (textElement instanceof TokenTextElement) {
            TokenTextElement tokenTextElement = (TokenTextElement)textElement;
            int tokenKind = tokenTextElement.getTokenKind();
            return tokenKind == 15 || tokenKind == 18 || tokenKind == 49 || tokenKind == 38 || tokenKind == 40 || tokenKind == 31 || tokenKind == 24;
        }
        return false;
    }

    private long cost() {
        return this.elements.stream().filter(e -> !(e instanceof Kept)).count();
    }

    public String toString() {
        return "Difference{" + this.elements + '}';
    }

    public List<DifferenceElement> getElements() {
        return this.elements;
    }

    void removeIndentationElements() {
        this.elements.removeIf(el -> el.getElement() instanceof CsmIndent || el.getElement() instanceof CsmUnindent);
    }

    private static class Removed
    implements DifferenceElement {
        final CsmElement element;

        public Removed(CsmElement element) {
            this.element = element;
        }

        public String toString() {
            return "Removed{" + this.element + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Removed removed = (Removed)o;
            return this.element.equals(removed.element);
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        @Override
        public CsmElement getElement() {
            return this.element;
        }

        @Override
        public boolean isAdded() {
            return false;
        }
    }

    private static class Kept
    implements DifferenceElement {
        final CsmElement element;

        public Kept(CsmElement element) {
            this.element = element;
        }

        public String toString() {
            return "Kept{" + this.element + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Kept kept = (Kept)o;
            return this.element.equals(kept.element);
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        @Override
        public CsmElement getElement() {
            return this.element;
        }

        @Override
        public boolean isAdded() {
            return false;
        }
    }

    private static class Reshuffled
    implements DifferenceElement {
        final CsmMix previousOrder;
        final CsmMix element;

        public Reshuffled(CsmMix previousOrder, CsmMix element) {
            this.previousOrder = previousOrder;
            this.element = element;
        }

        public String toString() {
            return "Reshuffled{" + this.element + ", previous=" + this.previousOrder + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Reshuffled that = (Reshuffled)o;
            if (!this.previousOrder.equals(that.previousOrder)) {
                return false;
            }
            return this.element.equals(that.element);
        }

        public int hashCode() {
            int result = this.previousOrder.hashCode();
            result = 31 * result + this.element.hashCode();
            return result;
        }

        @Override
        public CsmMix getElement() {
            return this.element;
        }

        @Override
        public boolean isAdded() {
            return false;
        }
    }

    private static class Added
    implements DifferenceElement {
        final CsmElement element;

        public Added(CsmElement element) {
            this.element = element;
        }

        public String toString() {
            return "Added{" + this.element + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Added added = (Added)o;
            return this.element.equals(added.element);
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        @Override
        public CsmElement getElement() {
            return this.element;
        }

        @Override
        public boolean isAdded() {
            return true;
        }
    }

    static interface DifferenceElement {
        public static DifferenceElement added(CsmElement element) {
            return new Added(element);
        }

        public static DifferenceElement removed(CsmElement element) {
            return new Removed(element);
        }

        public static DifferenceElement kept(CsmElement element) {
            return new Kept(element);
        }

        public CsmElement getElement();

        public boolean isAdded();
    }
}

