/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SourceZip {
    private final Path zipPath;
    private JavaParser javaParser;

    public SourceZip(Path zipPath) {
        this(zipPath, new ParserConfiguration());
    }

    public SourceZip(Path zipPath, ParserConfiguration configuration) {
        Utils.assertNotNull(zipPath);
        Utils.assertNotNull(configuration);
        this.zipPath = zipPath.normalize();
        this.javaParser = new JavaParser(configuration);
        Log.info("New source zip at \"%s\"", this.zipPath);
    }

    public List<Pair<Path, ParseResult<CompilationUnit>>> parse() throws IOException {
        Log.info("Parsing zip at \"%s\"", this.zipPath);
        ArrayList<Pair<Path, ParseResult<CompilationUnit>>> results = new ArrayList<Pair<Path, ParseResult<CompilationUnit>>>();
        this.parse((path, result) -> results.add(new Pair<Path, ParseResult>(path, result)));
        return results;
    }

    public SourceZip parse(Callback callback) throws IOException {
        Log.info("Parsing zip at \"%s\"", this.zipPath);
        try (ZipFile zipFile = new ZipFile(this.zipPath.toFile());){
            for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
                if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".java")) continue;
                Log.info("Parsing zip entry \"%s\"", zipEntry.getName());
                ParseResult<CompilationUnit> result = this.javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider(zipFile.getInputStream(zipEntry)));
                callback.process(Paths.get(zipEntry.getName(), new String[0]), result);
            }
        }
        return this;
    }

    public Path getZipPath() {
        return this.zipPath;
    }

    public JavaParser getJavaParser() {
        return this.javaParser;
    }

    public SourceZip setJavaParser(JavaParser javaParser) {
        Utils.assertNotNull(javaParser);
        this.javaParser = javaParser;
        return this;
    }

    @FunctionalInterface
    public static interface Callback {
        public void process(Path var1, ParseResult<CompilationUnit> var2);
    }
}

