/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.utils;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class SymbolSolverQuickSetup {
    private final Path root;
    private CombinedTypeSolver typeSolver = new CombinedTypeSolver(new ReflectionTypeSolver(false));
    private DirFilter dirFilter = path -> false;

    public SymbolSolverQuickSetup(Path root) {
        Utils.assertNotNull((Object)root);
        if (!Files.isDirectory(root, new LinkOption[0])) {
            throw new IllegalArgumentException("Only directories are allowed as root path!");
        }
        this.root = root.normalize();
        Log.info((String)"New symbol source root at \"%s\"", (Object[])new Object[]{this.root});
    }

    public SymbolSolverQuickSetup(Path root, DirFilter dirFilter) {
        this(root);
        this.dirFilter = dirFilter;
    }

    public TypeSolver walk() throws IOException {
        Files.walkFileTree(this.root, new JavaSymbolSolverWalker());
        Files.walkFileTree(this.root, new JarVisitor());
        return this.typeSolver;
    }

    public Optional<TypeSolver> tryToWalk() {
        try {
            return Optional.of(this.walk());
        }
        catch (IOException e) {
            Log.error((Throwable)e, (String)("Unable to walk root " + this.root), (Object[])new Object[0]);
            return Optional.empty();
        }
    }

    public TypeSolver getTypeSolver() {
        return this.typeSolver;
    }

    public Path getRoot() {
        return this.root;
    }

    private class JarVisitor
    extends SimpleFileVisitor<Path> {
        private JarVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
            PathMatcher matcher;
            if (attr.isRegularFile() && (matcher = FileSystems.getDefault().getPathMatcher("glob:**.jar")).matches(file)) {
                SymbolSolverQuickSetup.this.typeSolver.add(new JarTypeSolver(file.toString()));
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private class JavaSymbolSolverWalker
    extends SimpleFileVisitor<Path> {
        private final Set<Path> roots = new HashSet<Path>();

        private JavaSymbolSolverWalker() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws FileNotFoundException {
            PathMatcher matcher;
            if (attr.isRegularFile() && (matcher = FileSystems.getDefault().getPathMatcher("glob:**.java")).matches(file)) {
                try {
                    Optional<Path> root = JavaParser.parse((File)file.toFile()).getStorage().map(CompilationUnit.Storage::getSourceRoot);
                    if (root.isPresent()) {
                        SymbolSolverQuickSetup.this.typeSolver.add(new JavaParserTypeSolver(root.get().toFile()));
                        if (this.roots.add(root.get())) {
                            Log.trace((String)("Added dir " + root.get() + " to the TypeSolver"), (Object[])new Object[0]);
                            return FileVisitResult.SKIP_SIBLINGS;
                        }
                    }
                }
                catch (ParseProblemException e) {
                    Log.error((Throwable)e, (String)("Unable to parse file " + file), (Object[])new Object[0]);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            block3: {
                block2: {
                    if (Files.isHidden(dir) || SymbolSolverQuickSetup.this.dirFilter.filter(dir)) break block2;
                    if (!this.roots.stream().anyMatch(dir::startsWith)) break block3;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public static interface DirFilter {
        public boolean filter(Path var1);
    }
}

