/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.lang3.Validate;

public final class Files {
    private Files() {
    }

    public static String read(String location, Charset charset) throws IOException {
        return Files.read(Files.class.getResourceAsStream(location), charset);
    }

    public static String read(File source, Charset charset) throws IOException {
        return Files.read(new FileInputStream(source), charset);
    }

    public static String read(InputStream source, Charset charset) throws IOException {
        return Files.read(new InputStreamReader(source, charset));
    }

    public static String read(Reader source) throws IOException {
        return Files.read(new BufferedReader(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(BufferedReader source) throws IOException {
        Validate.notNull((Object)source, (String)"The input is required.", (Object[])new Object[0]);
        try {
            int ch = source.read();
            StringBuilder script = new StringBuilder();
            while (ch != -1) {
                script.append((char)ch);
                ch = source.read();
            }
            String string = script.toString();
            return string;
        }
        finally {
            source.close();
        }
    }
}

