/*
 * Decompiled with CFR 0.152.
 */
package com.github.joshelser.dropwizard.metrics.hadoop;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopMetrics2Reporter
extends ScheduledReporter
implements MetricsSource {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopMetrics2Reporter.class);
    private static final String EMPTY_STRING = "";
    public static final MetricsInfo RATE_UNIT_LABEL = Interns.info((String)"rate_unit", (String)"The unit of measure for rate metrics");
    public static final MetricsInfo DURATION_UNIT_LABEL = Interns.info((String)"duration_unit", (String)"The unit of measure of duration metrics");
    private final MetricsRegistry metrics2Registry;
    private final MetricsSystem metrics2System;
    private final String recordName;
    private final String context;
    private final ConcurrentLinkedQueue<Map.Entry<String, Gauge>> dropwizardGauges;
    private final ConcurrentLinkedQueue<Map.Entry<String, Counter>> dropwizardCounters;
    private final ConcurrentLinkedQueue<Map.Entry<String, Histogram>> dropwizardHistograms;
    private final ConcurrentLinkedQueue<Map.Entry<String, Meter>> dropwizardMeters;
    private final ConcurrentLinkedQueue<Map.Entry<String, Timer>> dropwizardTimers;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private HadoopMetrics2Reporter(MetricRegistry registry, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, MetricsSystem metrics2System, String jmxContext, String description, String recordName, String context) {
        super(registry, "hadoop-metrics2-reporter", filter, rateUnit, durationUnit);
        this.metrics2Registry = new MetricsRegistry(Interns.info((String)jmxContext, (String)description));
        this.metrics2System = metrics2System;
        this.recordName = recordName;
        this.context = context;
        this.dropwizardGauges = new ConcurrentLinkedQueue();
        this.dropwizardCounters = new ConcurrentLinkedQueue();
        this.dropwizardHistograms = new ConcurrentLinkedQueue();
        this.dropwizardMeters = new ConcurrentLinkedQueue();
        this.dropwizardTimers = new ConcurrentLinkedQueue();
        this.metrics2System.register(Objects.requireNonNull(jmxContext), Objects.requireNonNull(description), (Object)this);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(this.recordName);
        if (null != this.context) {
            builder.setContext(this.context);
        }
        this.snapshotAllMetrics(builder);
        this.metrics2Registry.snapshot(builder, all);
    }

    void snapshotAllMetrics(MetricsRecordBuilder builder) {
        Iterator<Map.Entry<String, Gauge>> gaugeIterator = this.dropwizardGauges.iterator();
        while (gaugeIterator.hasNext()) {
            Map.Entry<String, Gauge> gauge = gaugeIterator.next();
            MetricsInfo info = Interns.info((String)gauge.getKey(), (String)EMPTY_STRING);
            Object o = gauge.getValue().getValue();
            if (o instanceof Integer) {
                builder.addGauge(info, ((Integer)o).intValue());
            } else if (o instanceof Long) {
                builder.addGauge(info, ((Long)o).longValue());
            } else if (o instanceof Float) {
                builder.addGauge(info, ((Float)o).floatValue());
            } else if (o instanceof Double) {
                builder.addGauge(info, ((Double)o).doubleValue());
            } else {
                LOG.info("Ignoring Gauge ({}) with unhandled type: {}", (Object)gauge.getKey(), o.getClass());
            }
            gaugeIterator.remove();
        }
        Iterator<Map.Entry<String, Counter>> counterIterator = this.dropwizardCounters.iterator();
        while (counterIterator.hasNext()) {
            Map.Entry<String, Counter> counter = counterIterator.next();
            MetricsInfo info = Interns.info((String)counter.getKey(), (String)EMPTY_STRING);
            LOG.info("Adding counter {} {}", (Object)info, (Object)counter.getValue().getCount());
            builder.addCounter(info, counter.getValue().getCount());
            counterIterator.remove();
        }
        Iterator<Map.Entry<String, Histogram>> histogramIterator = this.dropwizardHistograms.iterator();
        while (histogramIterator.hasNext()) {
            Map.Entry<String, Histogram> entry = histogramIterator.next();
            String name = entry.getKey();
            Histogram histogram = entry.getValue();
            this.addSnapshot(builder, name, EMPTY_STRING, histogram.getSnapshot(), histogram.getCount());
            histogramIterator.remove();
        }
        Iterator<Map.Entry<String, Meter>> meterIterator = this.dropwizardMeters.iterator();
        while (meterIterator.hasNext()) {
            Map.Entry<String, Meter> meterEntry = meterIterator.next();
            String name = meterEntry.getKey();
            Meter meter = meterEntry.getValue();
            this.addMeter(builder, name, EMPTY_STRING, meter.getCount(), meter.getMeanRate(), meter.getOneMinuteRate(), meter.getFiveMinuteRate(), meter.getFifteenMinuteRate());
            meterIterator.remove();
        }
        Iterator<Map.Entry<String, Timer>> timerIterator = this.dropwizardTimers.iterator();
        while (timerIterator.hasNext()) {
            Map.Entry<String, Timer> timerEntry = timerIterator.next();
            String name = timerEntry.getKey();
            Timer timer = timerEntry.getValue();
            Snapshot snapshot = timer.getSnapshot();
            this.addMeter(builder, name, EMPTY_STRING, timer.getCount(), timer.getMeanRate(), timer.getOneMinuteRate(), timer.getFiveMinuteRate(), timer.getFifteenMinuteRate());
            this.addSnapshot(builder, name, EMPTY_STRING, snapshot);
            timerIterator.remove();
        }
        builder.tag(RATE_UNIT_LABEL, this.getRateUnit());
        builder.tag(DURATION_UNIT_LABEL, this.getDurationUnit());
    }

    private void addMeter(MetricsRecordBuilder builder, String name, String desc, long count, double meanRate, double oneMinuteRate, double fiveMinuteRate, double fifteenMinuteRate) {
        builder.addGauge(Interns.info((String)(name + "_count"), (String)EMPTY_STRING), count);
        builder.addGauge(Interns.info((String)(name + "_mean_rate"), (String)EMPTY_STRING), this.convertRate(meanRate));
        builder.addGauge(Interns.info((String)(name + "_1min_rate"), (String)EMPTY_STRING), this.convertRate(oneMinuteRate));
        builder.addGauge(Interns.info((String)(name + "_5min_rate"), (String)EMPTY_STRING), this.convertRate(fiveMinuteRate));
        builder.addGauge(Interns.info((String)(name + "_15min_rate"), (String)EMPTY_STRING), this.convertRate(fifteenMinuteRate));
    }

    private void addSnapshot(MetricsRecordBuilder builder, String name, String desc, Snapshot snapshot, long count) {
        builder.addGauge(Interns.info((String)(name + "_count"), (String)desc), count);
        this.addSnapshot(builder, name, desc, snapshot);
    }

    private void addSnapshot(MetricsRecordBuilder builder, String name, String desc, Snapshot snapshot) {
        builder.addGauge(Interns.info((String)(name + "_mean"), (String)desc), this.convertDuration(snapshot.getMean()));
        builder.addGauge(Interns.info((String)(name + "_min"), (String)desc), this.convertDuration(snapshot.getMin()));
        builder.addGauge(Interns.info((String)(name + "_max"), (String)desc), this.convertDuration(snapshot.getMax()));
        builder.addGauge(Interns.info((String)(name + "_median"), (String)desc), this.convertDuration(snapshot.getMedian()));
        builder.addGauge(Interns.info((String)(name + "_stddev"), (String)desc), this.convertDuration(snapshot.getStdDev()));
        builder.addGauge(Interns.info((String)(name + "_75thpercentile"), (String)desc), this.convertDuration(snapshot.get75thPercentile()));
        builder.addGauge(Interns.info((String)(name + "_95thpercentile"), (String)desc), this.convertDuration(snapshot.get95thPercentile()));
        builder.addGauge(Interns.info((String)(name + "_98thpercentile"), (String)desc), this.convertDuration(snapshot.get98thPercentile()));
        builder.addGauge(Interns.info((String)(name + "_99thpercentile"), (String)desc), this.convertDuration(snapshot.get99thPercentile()));
        builder.addGauge(Interns.info((String)(name + "_999thpercentile"), (String)desc), this.convertDuration(snapshot.get999thPercentile()));
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.dropwizardGauges.add(entry);
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.dropwizardCounters.add(entry);
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.dropwizardHistograms.add(entry);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.dropwizardMeters.add(entry);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.dropwizardTimers.add(entry);
        }
    }

    protected String getRateUnit() {
        return "events/" + super.getRateUnit();
    }

    protected String getDurationUnit() {
        return super.getDurationUnit();
    }

    protected double convertDuration(double duration) {
        return super.convertDuration(duration);
    }

    protected double convertRate(double rate) {
        return super.convertRate(rate);
    }

    MetricsRegistry getMetrics2Registry() {
        return this.metrics2Registry;
    }

    MetricsSystem getMetrics2System() {
        return this.metrics2System;
    }

    String getRecordName() {
        return this.recordName;
    }

    String getContext() {
        return this.context;
    }

    ConcurrentLinkedQueue<Map.Entry<String, Gauge>> getDropwizardGauges() {
        return this.dropwizardGauges;
    }

    ConcurrentLinkedQueue<Map.Entry<String, Counter>> getDropwizardCounters() {
        return this.dropwizardCounters;
    }

    ConcurrentLinkedQueue<Map.Entry<String, Histogram>> getDropwizardHistograms() {
        return this.dropwizardHistograms;
    }

    ConcurrentLinkedQueue<Map.Entry<String, Meter>> getDropwizardMeters() {
        return this.dropwizardMeters;
    }

    ConcurrentLinkedQueue<Map.Entry<String, Timer>> getDropwizardTimers() {
        return this.dropwizardTimers;
    }

    public static class Builder {
        private final MetricRegistry registry;
        private MetricFilter filter;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private String recordContext;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.filter = MetricFilter.ALL;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = Objects.requireNonNull(rateUnit);
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = Objects.requireNonNull(durationUnit);
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = Objects.requireNonNull(filter);
            return this;
        }

        public Builder recordContext(String recordContext) {
            this.recordContext = Objects.requireNonNull(recordContext);
            return this;
        }

        public HadoopMetrics2Reporter build(MetricsSystem metrics2System, String jmxContext, String description, String recordName) {
            return new HadoopMetrics2Reporter(this.registry, this.rateUnit, this.durationUnit, this.filter, metrics2System, Objects.requireNonNull(jmxContext), description, recordName, this.recordContext);
        }
    }
}

