/*
 * Decompiled with CFR 0.152.
 */
package com.kmood.datahandle;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.kmood.datahandle.Config;
import com.kmood.datahandle.DataHandler;
import com.kmood.datahandle.GlobalConfItemEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class DataConverter {
    public static Object convert(Object obj, Config conf) {
        GsonBuilder g = new GsonBuilder();
        GsonBuilder gsonBuilder = g.serializeNulls();
        if (conf != null) {
            final HashMap<String, DataHandler> keyConfMap = conf.getKeyConfMap();
            HashMap<String, String> keyGlobalConfrMap = conf.getKeyGlobalConfrMap();
            if (keyGlobalConfrMap != null && keyGlobalConfrMap.containsKey((Object)GlobalConfItemEnum.D_F)) {
                gsonBuilder.setDateFormat(keyGlobalConfrMap.get((Object)GlobalConfItemEnum.D_F));
                gsonBuilder.registerTypeAdapter(new TypeToken<HashMap<String, Object>>(){}.getType(), (Object)new TypeAdapter<Object>(){

                    public void write(JsonWriter out, Object value) throws IOException {
                        this.write(out, value);
                    }

                    public Object read(JsonReader in) throws IOException {
                        JsonToken token = in.peek();
                        String ActPath = in.getPath();
                        String path = ActPath.replaceAll("\\$\\.", "");
                        String path_ = path.replaceAll("\\[[0-9]{1,}]", "*").replaceAll("\\$\\.", "");
                        switch (token) {
                            case BEGIN_ARRAY: {
                                ArrayList<Object> list = new ArrayList<Object>();
                                in.beginArray();
                                while (in.hasNext()) {
                                    list.add(this.read(in));
                                }
                                in.endArray();
                                if (keyConfMap != null && keyConfMap.containsKey(path)) {
                                    return ((DataHandler)keyConfMap.get(path)).ObjHandle(list);
                                }
                                if (keyConfMap != null && keyConfMap.containsKey(path_)) {
                                    return ((DataHandler)keyConfMap.get(path_)).ObjHandle(list);
                                }
                                return list;
                            }
                            case BEGIN_OBJECT: {
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                in.beginObject();
                                while (in.hasNext()) {
                                    map.put(in.nextName(), this.read(in));
                                }
                                in.endObject();
                                if (keyConfMap != null && keyConfMap.containsKey(path)) {
                                    return ((DataHandler)keyConfMap.get(path)).ObjHandle(map);
                                }
                                if (keyConfMap != null && keyConfMap.containsKey(path_)) {
                                    return ((DataHandler)keyConfMap.get(path_)).ObjHandle(map);
                                }
                                return map;
                            }
                            case STRING: {
                                String s = in.nextString();
                                if (keyConfMap != null && keyConfMap.containsKey(path)) {
                                    return ((DataHandler)keyConfMap.get(path)).ObjHandle(s);
                                }
                                if (keyConfMap != null && keyConfMap.containsKey(path_)) {
                                    return ((DataHandler)keyConfMap.get(path_)).ObjHandle(s);
                                }
                                return s;
                            }
                            case NUMBER: {
                                double dbNum = in.nextDouble();
                                if (keyConfMap != null && keyConfMap.containsKey(path)) {
                                    return ((DataHandler)keyConfMap.get(path)).ObjHandle(dbNum);
                                }
                                if (keyConfMap != null && keyConfMap.containsKey(path_)) {
                                    return ((DataHandler)keyConfMap.get(path_)).ObjHandle(dbNum);
                                }
                                if (dbNum > 9.223372036854776E18) {
                                    return dbNum;
                                }
                                long lngNum = (long)dbNum;
                                if (dbNum == (double)lngNum) {
                                    return lngNum;
                                }
                                return dbNum;
                            }
                            case BOOLEAN: {
                                return in.nextBoolean();
                            }
                            case NULL: {
                                in.nextNull();
                                if (keyConfMap != null && keyConfMap.containsKey(path)) {
                                    return ((DataHandler)keyConfMap.get(path)).ObjHandle(null);
                                }
                                if (keyConfMap != null && keyConfMap.containsKey(path_)) {
                                    return ((DataHandler)keyConfMap.get(path_)).ObjHandle(null);
                                }
                                return null;
                            }
                        }
                        throw new IllegalStateException();
                    }
                });
            }
        }
        Gson gson = gsonBuilder.create();
        String s = gson.toJson(obj);
        s = s.replaceAll("\\\\u0026", "&amp;").replaceAll("\\\\u003c", "&lt;").replaceAll("\\\\u003e", "&gt;");
        Object o = gson.fromJson(s, new TypeToken<HashMap<String, Object>>(){}.getType());
        return o;
    }
}

