/*
 * Decompiled with CFR 0.152.
 */
package com.kmood.datahandle;

import com.kmood.datahandle.Config;
import com.kmood.datahandle.DataConverter;
import com.kmood.datahandle.FMConfiguration;
import com.kmood.utils.StringUtil;
import com.kmood.word.WordModelHandlerImpl;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class DocumentProducer {
    private ThreadLocal<String> ActualModelPathLocal = new ThreadLocal();
    private ThreadLocal<String> ActualModelNameLocal = new ThreadLocal();

    public DocumentProducer(Configuration CustomerConfig, String ActualModelPath) {
        FMConfiguration.Init(CustomerConfig);
        this.ActualModelPathLocal.set(ActualModelPath);
    }

    public DocumentProducer(String ActualModelPath) throws Exception {
        FMConfiguration.Init();
        Configuration configuration = FMConfiguration.addFMModelPath(ActualModelPath);
        this.ActualModelPathLocal.set(ActualModelPath);
    }

    public DocumentProducer() throws Exception {
        FMConfiguration.Init();
    }

    public String Complie(String XmlModelPath, String XmlModelName, boolean debugModel) throws Exception {
        if (StringUtil.isBlank((CharSequence)this.ActualModelPathLocal.get())) {
            FMConfiguration.addFMModelPath(XmlModelPath);
            this.ActualModelPathLocal.set(XmlModelPath);
        }
        if (debugModel) {
            WordModelHandlerImpl wordXmlModelHandler = new WordModelHandlerImpl();
            String string = wordXmlModelHandler.WordXmlModelHandle(XmlModelPath + File.separator + XmlModelName, this.ActualModelPathLocal.get());
        }
        this.ActualModelNameLocal.set(XmlModelName + ".ftl");
        return XmlModelPath + File.separator + XmlModelName + ".ftl";
    }

    public void produce(Object data, String ProduceFilePath) throws IOException, TemplateException {
        Configuration configuration = FMConfiguration.getConfiguration();
        Template template = configuration.getTemplate(this.ActualModelNameLocal.get());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ProduceFilePath), template.getEncoding());
        Object dataConvert = DataConverter.convert(data, null);
        template.process(dataConvert, (Writer)outputStreamWriter);
    }

    public void produce(Object data, OutputStream ProduceFileout) throws IOException, TemplateException {
        Configuration configuration = FMConfiguration.getConfiguration();
        Template template = configuration.getTemplate(this.ActualModelNameLocal.get());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(ProduceFileout, template.getEncoding());
        Object dataConvert = DataConverter.convert(data, null);
        template.process(dataConvert, (Writer)outputStreamWriter);
    }

    public void produce(Object data, OutputStream ProduceFileout, Config config) throws IOException, TemplateException {
        Configuration configuration = FMConfiguration.getConfiguration();
        Template template = configuration.getTemplate(this.ActualModelNameLocal.get());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(ProduceFileout, template.getEncoding());
        Object dataConvert = DataConverter.convert(data, config);
        template.process(dataConvert, (Writer)outputStreamWriter);
    }

    public void produce(Object data, String ProduceFilePath, Config config) throws IOException, TemplateException {
        Configuration configuration = FMConfiguration.getConfiguration();
        Template template = configuration.getTemplate(this.ActualModelNameLocal.get());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ProduceFilePath), template.getEncoding());
        Object dataConvert = DataConverter.convert(data, config);
        template.process(dataConvert, (Writer)outputStreamWriter);
    }
}

