/*
 * Decompiled with CFR 0.152.
 */
package com.kmood.utils;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    public static String substringBefore(String str, String separator, int index) {
        if (str == null) {
            return null;
        }
        if (separator == null) {
            return str;
        }
        String[] str_arr = str.split("_");
        if (str_arr.length < 1 || index > str_arr.length) {
            return str;
        }
        if (index == 0) {
            return str;
        }
        int index_ = str_arr.length + index;
        if (index_ <= 0) {
            return str;
        }
        if (index < 0) {
            index = index_;
        }
        String result = "";
        for (int i = 0; i < index; ++i) {
            result = result + str_arr[i] + separator;
        }
        return StringUtil.substringBeforeLast(result, "_");
    }

    public static String removeInvisibleChar(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return "";
        }
        return str.replaceAll("[\\x00-\\x1F | \\x7F ]", "").replaceAll("\u3000", "");
    }

    public static String substringBeforeAfterSize(String data, int i, int size) {
        String pre = "";
        String sub = "";
        if (data == null && data.length() == 0) {
            return "";
        }
        int l = data.length();
        if (i > l - 1) {
            return data.substring(l - size, l);
        }
        if (i <= 0 && data.length() < size) {
            return data;
        }
        if (i <= 0 && data.length() > size) {
            return data.substring(0, size);
        }
        pre = i <= size ? data.substring(0, i) : data.substring(i - size, i);
        sub = i >= l - size ? data.substring(i, l) : data.substring(i, i + size);
        return pre + sub;
    }

    public static String substringBefore(String str, String separator) {
        if (str == null || str.length() == 0 || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringBeforeLast(String str, String separator) {
        if (str == null || "".equals(str) || separator == null || "".equals(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringAfter(String str, String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String[] substringsBetween(String str, String open, String close) {
        int end;
        int start;
        if (str == null || open == null || open.length() == 0 || close == null || close.length() == 0) {
            return null;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int closeLen = close.length();
        int openLen = open.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen - closeLen && (start = str.indexOf(open, pos)) >= 0 && (end = str.indexOf(close, start += openLen)) >= 0) {
            list.add(str.substring(start, end));
            pos = end + closeLen;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }
}

