/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kongchen.swagger.docgen.GenerateException;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SecurityDefinition {
    private String name;
    private String type;
    private String description;
    private String json;

    public Map<String, SecuritySchemeDefinition> getDefinitions() throws GenerateException {
        HashMap<String, SecuritySchemeDefinition> map = new HashMap<String, SecuritySchemeDefinition>();
        if (this.name != null && this.type != null) {
            map.put(this.name, this.getSecuritySchemeDefinitionByNameAndType());
        } else if (this.json != null) {
            try {
                JsonNode tree = new ObjectMapper().readTree(this.getClass().getResourceAsStream(this.json));
                Iterator fit = tree.fieldNames();
                while (fit.hasNext()) {
                    String field = (String)fit.next();
                    JsonNode node = tree.get(field);
                    String type = node.get("type").asText();
                    SecuritySchemeDefinition ssd = this.getSecuritySchemeDefinitionByType(type, node);
                    if (ssd == null) continue;
                    map.put(field, ssd);
                }
            }
            catch (IOException e) {
                throw new GenerateException(e);
            }
        }
        return map;
    }

    private SecuritySchemeDefinition getSecuritySchemeDefinitionByType(String type, JsonNode node) throws GenerateException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            OAuth2Definition def = null;
            if (type.equals(new OAuth2Definition().getType())) {
                def = new OAuth2Definition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), OAuth2Definition.class);
                }
            } else if (type.equals(new BasicAuthDefinition().getType())) {
                def = new BasicAuthDefinition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), BasicAuthDefinition.class);
                }
            } else if (type.equals(new ApiKeyAuthDefinition().getType())) {
                def = new ApiKeyAuthDefinition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), ApiKeyAuthDefinition.class);
                }
            }
            return def;
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    private SecuritySchemeDefinition getSecuritySchemeDefinitionByNameAndType() throws GenerateException {
        final String _type = this.type;
        final String _description = this.description;
        SecuritySchemeDefinition def = new SecuritySchemeDefinition(){
            private String type;
            private String description;
            private Map<String, Object> vendorExtensions;
            {
                this.type = _type;
                this.description = _description;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public Map<String, Object> getVendorExtensions() {
                return this.vendorExtensions;
            }

            public void setVendorExtension(String key, Object value) {
                this.vendorExtensions.put(key, value);
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String description) {
                this.description = description;
            }
        };
        JsonNode node = new ObjectMapper().valueToTree((Object)def);
        return this.getSecuritySchemeDefinitionByType(this.type, node);
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

