/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.config;

import com.github.lianjiatech.retrofit.spring.boot.config.DegradeProperty;
import com.github.lianjiatech.retrofit.spring.boot.config.LogProperty;
import com.github.lianjiatech.retrofit.spring.boot.config.PoolConfig;
import com.github.lianjiatech.retrofit.spring.boot.config.RetryProperty;
import com.github.lianjiatech.retrofit.spring.boot.core.BodyCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.ResponseCallAdapterFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.converter.jackson.JacksonConverterFactory;

@ConfigurationProperties(prefix="retrofit")
public class RetrofitProperties {
    private static final String DEFAULT_POOL = "default";
    @NestedConfigurationProperty
    private Map<String, PoolConfig> pool = new LinkedHashMap<String, PoolConfig>();
    @NestedConfigurationProperty
    private RetryProperty retry = new RetryProperty();
    @NestedConfigurationProperty
    private DegradeProperty degrade = new DegradeProperty();
    @NestedConfigurationProperty
    private LogProperty log = new LogProperty();
    private boolean disableVoidReturnType = false;
    private Class<? extends Converter.Factory>[] globalConverterFactories = new Class[]{JacksonConverterFactory.class};
    private Class<? extends CallAdapter.Factory>[] globalCallAdapterFactories = new Class[]{BodyCallAdapterFactory.class, ResponseCallAdapterFactory.class};

    public Map<String, PoolConfig> getPool() {
        if (!this.pool.isEmpty()) {
            return this.pool;
        }
        this.pool.put(DEFAULT_POOL, new PoolConfig(5, 300L));
        return this.pool;
    }

    public void setPool(Map<String, PoolConfig> pool) {
        this.pool = pool;
    }

    public boolean isDisableVoidReturnType() {
        return this.disableVoidReturnType;
    }

    public void setDisableVoidReturnType(boolean disableVoidReturnType) {
        this.disableVoidReturnType = disableVoidReturnType;
    }

    public Class<? extends Converter.Factory>[] getGlobalConverterFactories() {
        return this.globalConverterFactories;
    }

    public void setGlobalConverterFactories(Class<? extends Converter.Factory>[] globalConverterFactories) {
        this.globalConverterFactories = globalConverterFactories;
    }

    public Class<? extends CallAdapter.Factory>[] getGlobalCallAdapterFactories() {
        return this.globalCallAdapterFactories;
    }

    public void setGlobalCallAdapterFactories(Class<? extends CallAdapter.Factory>[] globalCallAdapterFactories) {
        this.globalCallAdapterFactories = globalCallAdapterFactories;
    }

    public RetryProperty getRetry() {
        return this.retry;
    }

    public void setRetry(RetryProperty retry) {
        this.retry = retry;
    }

    public DegradeProperty getDegrade() {
        return this.degrade;
    }

    public void setDegrade(DegradeProperty degrade) {
        this.degrade = degrade;
    }

    public LogProperty getLog() {
        return this.log;
    }

    public void setLog(LogProperty log) {
        this.log = log;
    }
}

