/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.annotation.Intercept;
import com.github.lianjiatech.retrofit.spring.boot.annotation.InterceptMark;
import com.github.lianjiatech.retrofit.spring.boot.annotation.Intercepts;
import com.github.lianjiatech.retrofit.spring.boot.annotation.OkHttpClientBuilder;
import com.github.lianjiatech.retrofit.spring.boot.annotation.RetrofitClient;
import com.github.lianjiatech.retrofit.spring.boot.config.DegradeProperty;
import com.github.lianjiatech.retrofit.spring.boot.config.LogProperty;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitConfigBean;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitProperties;
import com.github.lianjiatech.retrofit.spring.boot.core.ErrorDecoder;
import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitInvocationHandler;
import com.github.lianjiatech.retrofit.spring.boot.degrade.BaseResourceNameParser;
import com.github.lianjiatech.retrofit.spring.boot.degrade.Degrade;
import com.github.lianjiatech.retrofit.spring.boot.degrade.DegradeStrategy;
import com.github.lianjiatech.retrofit.spring.boot.degrade.DegradeType;
import com.github.lianjiatech.retrofit.spring.boot.degrade.FallbackFactory;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitDegradeRule;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitDegradeRuleInitializer;
import com.github.lianjiatech.retrofit.spring.boot.degrade.SentinelDegradeInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseGlobalInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseLoggingInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.ErrorDecoderInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.LogStrategy;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.NetworkInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.ServiceInstanceChooserInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.retry.BaseRetryInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.util.ApplicationContextUtils;
import com.github.lianjiatech.retrofit.spring.boot.util.BeanExtendUtils;
import com.github.lianjiatech.retrofit.spring.boot.util.RetrofitUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class RetrofitFactoryBean<T>
implements FactoryBean<T>,
EnvironmentAware,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RetrofitFactoryBean.class);
    private static final Map<Class<? extends CallAdapter.Factory>, CallAdapter.Factory> CALL_ADAPTER_FACTORIES_CACHE = new HashMap<Class<? extends CallAdapter.Factory>, CallAdapter.Factory>(4);
    private Class<T> retrofitInterface;
    private Environment environment;
    private RetrofitProperties retrofitProperties;
    private RetrofitConfigBean retrofitConfigBean;
    private ApplicationContext applicationContext;
    private RetrofitClient retrofitClient;
    private static final Map<Class<? extends Converter.Factory>, Converter.Factory> CONVERTER_FACTORIES_CACHE = new HashMap<Class<? extends Converter.Factory>, Converter.Factory>(4);

    public RetrofitFactoryBean(Class<T> retrofitInterface) {
        this.retrofitInterface = retrofitInterface;
        this.retrofitClient = retrofitInterface.getAnnotation(RetrofitClient.class);
    }

    public T getObject() throws Exception {
        this.checkRetrofitInterface(this.retrofitInterface);
        Retrofit retrofit = this.getRetrofit(this.retrofitInterface);
        Object source = retrofit.create(this.retrofitInterface);
        RetrofitProperties retrofitProperties = this.retrofitConfigBean.getRetrofitProperties();
        Class<?> fallbackClass = this.retrofitClient.fallback();
        Object fallback = null;
        if (!Void.TYPE.isAssignableFrom(fallbackClass)) {
            fallback = ApplicationContextUtils.getBean(this.applicationContext, fallbackClass);
        }
        Class<?> fallbackFactoryClass = this.retrofitClient.fallbackFactory();
        FallbackFactory fallbackFactory = null;
        if (!Void.TYPE.isAssignableFrom(fallbackFactoryClass)) {
            fallbackFactory = (FallbackFactory)ApplicationContextUtils.getBean(this.applicationContext, fallbackFactoryClass);
        }
        this.loadDegradeRules();
        return (T)Proxy.newProxyInstance(this.retrofitInterface.getClassLoader(), new Class[]{this.retrofitInterface}, (InvocationHandler)new RetrofitInvocationHandler(source, fallback, fallbackFactory, retrofitProperties));
    }

    private void loadDegradeRules() {
        Method[] methods;
        for (Method method : methods = this.retrofitInterface.getMethods()) {
            Degrade degrade;
            int modifiers;
            if (method.isDefault() || Modifier.isStatic(modifiers = method.getModifiers()) || (degrade = method.isAnnotationPresent(Degrade.class) ? method.getAnnotation(Degrade.class) : this.retrofitInterface.getAnnotation(Degrade.class)) == null) continue;
            DegradeStrategy degradeStrategy = degrade.degradeStrategy();
            BaseResourceNameParser resourceNameParser = this.retrofitConfigBean.getResourceNameParser();
            String resourceName = resourceNameParser.parseResourceName(method, this.environment);
            RetrofitDegradeRule degradeRule = new RetrofitDegradeRule();
            degradeRule.setCount(degrade.count());
            degradeRule.setDegradeStrategy(degradeStrategy);
            degradeRule.setTimeWindow(degrade.timeWindow());
            degradeRule.setResourceName(resourceName);
            RetrofitDegradeRuleInitializer.addRetrofitDegradeRule(degradeRule);
        }
    }

    private void checkRetrofitInterface(Class<T> retrofitInterface) {
        Class<?> fallbackFactoryClass;
        Assert.isTrue((boolean)retrofitInterface.isInterface(), (String)"@RetrofitClient can only be marked on the interface type!");
        Method[] methods = retrofitInterface.getMethods();
        Assert.isTrue((StringUtils.hasText((String)this.retrofitClient.baseUrl()) || StringUtils.hasText((String)this.retrofitClient.serviceId()) ? 1 : 0) != 0, (String)"@RetrofitClient's baseUrl and serviceId must be configured with one\uff01");
        for (Method method : methods) {
            Class<?> returnType = method.getReturnType();
            if (method.isAnnotationPresent(OkHttpClientBuilder.class)) {
                Assert.isTrue((boolean)returnType.equals(OkHttpClient.Builder.class), (String)"For methods annotated by @OkHttpClientBuilder, the return value must be OkHttpClient.Builder\uff01");
                Assert.isTrue((boolean)Modifier.isStatic(method.getModifiers()), (String)"only static method can annotated by @OkHttpClientBuilder!");
                continue;
            }
            Assert.isTrue((!Void.TYPE.isAssignableFrom(returnType) ? 1 : 0) != 0, (String)("The void keyword is not supported as the return type, please use java.lang.Void\uff01 method=" + method));
            if (!this.retrofitProperties.isDisableVoidReturnType()) continue;
            Assert.isTrue((!Void.class.isAssignableFrom(returnType) ? 1 : 0) != 0, (String)("Configured to disable Void as the return value, please specify another return type!method=" + method));
        }
        Class<?> fallbackClass = this.retrofitClient.fallback();
        if (!Void.TYPE.isAssignableFrom(fallbackClass)) {
            Assert.isTrue((boolean)retrofitInterface.isAssignableFrom(fallbackClass), (String)("The fallback type must implement the current interface\uff01the fallback type is " + fallbackClass));
            Object fallback = ApplicationContextUtils.getBean(this.applicationContext, fallbackClass);
            Assert.notNull(fallback, (String)("fallback  must be a valid spring bean! the fallback class is " + fallbackClass));
        }
        if (!Void.TYPE.isAssignableFrom(fallbackFactoryClass = this.retrofitClient.fallbackFactory())) {
            Assert.isTrue((boolean)FallbackFactory.class.isAssignableFrom(fallbackFactoryClass), (String)("The fallback factory type must implement FallbackFactory\uff01the fallback factory is " + fallbackFactoryClass));
            Object fallbackFactory = ApplicationContextUtils.getBean(this.applicationContext, fallbackFactoryClass);
            Assert.notNull(fallbackFactory, (String)("fallback factory  must be a valid spring bean! the fallback factory class is " + fallbackFactoryClass));
        }
    }

    public Class<T> getObjectType() {
        return this.retrofitInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    private synchronized ConnectionPool getConnectionPool(Class<?> retrofitClientInterfaceClass) {
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        String poolName = retrofitClient.poolName();
        Map<String, ConnectionPool> poolRegistry = this.retrofitConfigBean.getPoolRegistry();
        Assert.notNull(poolRegistry, (String)"poolRegistry does not exist! Please set retrofitConfigBean.poolRegistry!");
        ConnectionPool connectionPool = poolRegistry.get(poolName);
        Assert.notNull((Object)connectionPool, (String)("The connection pool corresponding to the current poolName does not exist! poolName = " + poolName));
        return connectionPool;
    }

    private synchronized OkHttpClient getOkHttpClient(Class<?> retrofitClientInterfaceClass) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Collection<NetworkInterceptor> networkInterceptors;
        Class<? extends ErrorDecoder> errorDecoderClass;
        ErrorDecoder decoder;
        ServiceInstanceChooserInterceptor serviceInstanceChooserInterceptor;
        OkHttpClient.Builder okHttpClientBuilder;
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        Method method = this.findOkHttpClientBuilderMethod(retrofitClientInterfaceClass);
        if (method != null) {
            okHttpClientBuilder = (OkHttpClient.Builder)method.invoke(null, new Object[0]);
        } else {
            ConnectionPool connectionPool = this.getConnectionPool(retrofitClientInterfaceClass);
            okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout((long)retrofitClient.connectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout((long)retrofitClient.readTimeoutMs(), TimeUnit.MILLISECONDS).writeTimeout((long)retrofitClient.writeTimeoutMs(), TimeUnit.MILLISECONDS).callTimeout((long)retrofitClient.callTimeoutMs(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(retrofitClient.retryOnConnectionFailure()).followRedirects(retrofitClient.followRedirects()).followSslRedirects(retrofitClient.followSslRedirects()).pingInterval((long)retrofitClient.pingIntervalMs(), TimeUnit.MILLISECONDS).connectionPool(connectionPool);
        }
        DegradeProperty degradeProperty = this.retrofitProperties.getDegrade();
        if (degradeProperty.isEnable()) {
            DegradeType degradeType = degradeProperty.getDegradeType();
            switch (degradeType) {
                case SENTINEL: {
                    try {
                        Class.forName("com.alibaba.csp.sentinel.SphU");
                        SentinelDegradeInterceptor sentinelDegradeInterceptor = new SentinelDegradeInterceptor();
                        sentinelDegradeInterceptor.setEnvironment(this.environment);
                        sentinelDegradeInterceptor.setResourceNameParser(this.retrofitConfigBean.getResourceNameParser());
                        okHttpClientBuilder.addInterceptor((Interceptor)sentinelDegradeInterceptor);
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn("com.alibaba.csp.sentinel not found! No SentinelDegradeInterceptor is set.");
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not currently supported! degradeType=" + (Object)((Object)degradeType));
                }
            }
        }
        if (StringUtils.hasText((String)retrofitClient.serviceId()) && (serviceInstanceChooserInterceptor = this.retrofitConfigBean.getServiceInstanceChooserInterceptor()) != null) {
            okHttpClientBuilder.addInterceptor((Interceptor)serviceInstanceChooserInterceptor);
        }
        if ((decoder = ApplicationContextUtils.getBean(this.applicationContext, errorDecoderClass = retrofitClient.errorDecoder())) == null) {
            decoder = errorDecoderClass.newInstance();
        }
        ErrorDecoderInterceptor decoderInterceptor = ErrorDecoderInterceptor.create(decoder);
        okHttpClientBuilder.addInterceptor((Interceptor)decoderInterceptor);
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(this.findInterceptorByAnnotation(retrofitClientInterfaceClass));
        Collection<BaseGlobalInterceptor> globalInterceptors = this.retrofitConfigBean.getGlobalInterceptors();
        if (!CollectionUtils.isEmpty(globalInterceptors)) {
            interceptors.addAll(globalInterceptors);
        }
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        BaseRetryInterceptor retryInterceptor = this.retrofitConfigBean.getRetryInterceptor();
        okHttpClientBuilder.addInterceptor((Interceptor)retryInterceptor);
        LogProperty logProperty = this.retrofitProperties.getLog();
        if (logProperty.isEnable() && retrofitClient.enableLog()) {
            Class<? extends BaseLoggingInterceptor> loggingInterceptorClass = logProperty.getLoggingInterceptor();
            Constructor<? extends BaseLoggingInterceptor> constructor = loggingInterceptorClass.getConstructor(Level.class, LogStrategy.class);
            BaseLoggingInterceptor loggingInterceptor = constructor.newInstance(new Object[]{retrofitClient.logLevel(), retrofitClient.logStrategy()});
            okHttpClientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
        }
        if (!CollectionUtils.isEmpty(networkInterceptors = this.retrofitConfigBean.getNetworkInterceptors())) {
            for (NetworkInterceptor networkInterceptor : networkInterceptors) {
                okHttpClientBuilder.addNetworkInterceptor((Interceptor)networkInterceptor);
            }
        }
        return okHttpClientBuilder.build();
    }

    private Method findOkHttpClientBuilderMethod(Class<?> retrofitClientInterfaceClass) {
        Method[] methods;
        for (Method method : methods = retrofitClientInterfaceClass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(OkHttpClientBuilder.class) || !method.getReturnType().equals(OkHttpClient.Builder.class)) continue;
            return method;
        }
        return null;
    }

    private List<Interceptor> findInterceptorByAnnotation(Class<?> retrofitClientInterfaceClass) throws InstantiationException, IllegalAccessException {
        Annotation[] classAnnotations = retrofitClientInterfaceClass.getAnnotations();
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        ArrayList<Annotation> interceptAnnotations = new ArrayList<Annotation>();
        for (Annotation classAnnotation : classAnnotations) {
            Intercept[] value2;
            Class<? extends Annotation> annotationType = classAnnotation.annotationType();
            if (annotationType.isAnnotationPresent(InterceptMark.class)) {
                interceptAnnotations.add(classAnnotation);
            }
            if (!(classAnnotation instanceof Intercepts)) continue;
            for (Intercept intercept : value2 = ((Intercepts)classAnnotation).value()) {
                interceptAnnotations.add(intercept);
            }
        }
        for (Annotation interceptAnnotation : interceptAnnotations) {
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)interceptAnnotation);
            Object handler = annotationAttributes.get("handler");
            Assert.notNull(handler, (String)"@InterceptMark annotations must be configured: Class<? extends BasePathMatchInterceptor> handler()");
            Assert.notNull(annotationAttributes.get("include"), (String)"@InterceptMark annotations must be configured: String[] include()");
            Assert.notNull(annotationAttributes.get("exclude"), (String)"@InterceptMark annotations must be configured: String[] exclude()");
            Class interceptorClass = (Class)handler;
            BasePathMatchInterceptor interceptor = this.getInterceptorInstance(interceptorClass);
            HashMap annotationResolveAttributes = new HashMap(8);
            annotationAttributes.forEach((key, value) -> {
                if (value instanceof String) {
                    String newValue = this.environment.resolvePlaceholders((String)value);
                    annotationResolveAttributes.put(key, newValue);
                } else {
                    annotationResolveAttributes.put(key, value);
                }
            });
            BeanExtendUtils.populate(interceptor, annotationResolveAttributes);
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private BasePathMatchInterceptor getInterceptorInstance(Class<? extends BasePathMatchInterceptor> interceptorClass) throws IllegalAccessException, InstantiationException {
        try {
            return (BasePathMatchInterceptor)this.applicationContext.getBean(interceptorClass);
        }
        catch (BeansException e) {
            return interceptorClass.newInstance();
        }
    }

    private synchronized Retrofit getRetrofit(Class<?> retrofitClientInterfaceClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<? extends Converter.Factory>[] globalConverterFactoryClasses;
        Class<? extends Converter.Factory>[] converterFactoryClasses;
        List<Converter.Factory> converterFactories;
        Class<? extends CallAdapter.Factory>[] globalCallAdapterFactoryClasses;
        RetrofitClient retrofitClient = retrofitClientInterfaceClass.getAnnotation(RetrofitClient.class);
        String baseUrl = retrofitClient.baseUrl();
        baseUrl = RetrofitUtils.convertBaseUrl(retrofitClient, baseUrl, this.environment);
        OkHttpClient client = this.getOkHttpClient(retrofitClientInterfaceClass);
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).validateEagerly(retrofitClient.validateEagerly()).client(client);
        Class<? extends CallAdapter.Factory>[] callAdapterFactoryClasses = retrofitClient.callAdapterFactories();
        List<CallAdapter.Factory> callAdapterFactories = this.getCallAdapterFactories(callAdapterFactoryClasses, globalCallAdapterFactoryClasses = this.retrofitConfigBean.getGlobalCallAdapterFactoryClasses());
        if (!CollectionUtils.isEmpty(callAdapterFactories)) {
            callAdapterFactories.forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addCallAdapterFactory(arg_0));
        }
        if (!CollectionUtils.isEmpty(converterFactories = this.getConverterFactories(converterFactoryClasses = retrofitClient.converterFactories(), globalConverterFactoryClasses = this.retrofitConfigBean.getGlobalConverterFactoryClasses()))) {
            converterFactories.forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addConverterFactory(arg_0));
        }
        return retrofitBuilder.build();
    }

    private List<CallAdapter.Factory> getCallAdapterFactories(Class<? extends CallAdapter.Factory>[] callAdapterFactoryClasses, Class<? extends CallAdapter.Factory>[] globalCallAdapterFactoryClasses) throws IllegalAccessException, InstantiationException {
        ArrayList<Class<? extends CallAdapter.Factory>> combineCallAdapterFactoryClasses = new ArrayList<Class<? extends CallAdapter.Factory>>();
        if (callAdapterFactoryClasses != null && callAdapterFactoryClasses.length != 0) {
            combineCallAdapterFactoryClasses.addAll(Arrays.asList(callAdapterFactoryClasses));
        }
        if (globalCallAdapterFactoryClasses != null && globalCallAdapterFactoryClasses.length != 0) {
            combineCallAdapterFactoryClasses.addAll(Arrays.asList(globalCallAdapterFactoryClasses));
        }
        if (combineCallAdapterFactoryClasses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>();
        for (Class clazz : combineCallAdapterFactoryClasses) {
            CallAdapter.Factory callAdapterFactory = CALL_ADAPTER_FACTORIES_CACHE.get(clazz);
            if (callAdapterFactory == null) {
                callAdapterFactory = (CallAdapter.Factory)ApplicationContextUtils.getBean(this.applicationContext, clazz);
                if (callAdapterFactory == null) {
                    callAdapterFactory = (CallAdapter.Factory)clazz.newInstance();
                }
                CALL_ADAPTER_FACTORIES_CACHE.put(clazz, callAdapterFactory);
            }
            callAdapterFactories.add(callAdapterFactory);
        }
        return callAdapterFactories;
    }

    private List<Converter.Factory> getConverterFactories(Class<? extends Converter.Factory>[] converterFactoryClasses, Class<? extends Converter.Factory>[] globalConverterFactoryClasses) throws IllegalAccessException, InstantiationException {
        ArrayList<Class<? extends Converter.Factory>> combineConverterFactoryClasses = new ArrayList<Class<? extends Converter.Factory>>();
        if (converterFactoryClasses != null && converterFactoryClasses.length != 0) {
            combineConverterFactoryClasses.addAll(Arrays.asList(converterFactoryClasses));
        }
        if (globalConverterFactoryClasses != null && globalConverterFactoryClasses.length != 0) {
            combineConverterFactoryClasses.addAll(Arrays.asList(globalConverterFactoryClasses));
        }
        if (combineConverterFactoryClasses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>();
        for (Class clazz : combineConverterFactoryClasses) {
            Converter.Factory converterFactory = CONVERTER_FACTORIES_CACHE.get(clazz);
            if (converterFactory == null) {
                converterFactory = (Converter.Factory)ApplicationContextUtils.getBean(this.applicationContext, clazz);
                if (converterFactory == null) {
                    converterFactory = (Converter.Factory)clazz.newInstance();
                }
                CONVERTER_FACTORIES_CACHE.put(clazz, converterFactory);
            }
            converterFactories.add(converterFactory);
        }
        return converterFactories;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.retrofitConfigBean = (RetrofitConfigBean)applicationContext.getBean(RetrofitConfigBean.class);
        this.retrofitProperties = this.retrofitConfigBean.getRetrofitProperties();
    }
}

