/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.retry;

import com.github.lianjiatech.retrofit.spring.boot.retry.BaseRetryInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.retry.RetryRule;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRetryInterceptor
extends BaseRetryInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRetryInterceptor.class);

    @Override
    protected Response retryIntercept(int maxRetries, int intervalMs, RetryRule[] retryRules, Interceptor.Chain chain) throws IOException, InterruptedException {
        while (true) {
            try {
                Response response;
                while (true) {
                    Request request = chain.request();
                    response = chain.proceed(request);
                    if (!this.containRetryRule(retryRules, RetryRule.RESPONSE_STATUS_NOT_2XX)) break;
                    if (response.isSuccessful()) {
                        return response;
                    }
                    logger.debug("The response fails, retry is performed! The response code is " + response.code());
                    if (--maxRetries < 0) {
                        return response;
                    }
                    response.close();
                    Thread.sleep(intervalMs);
                }
                return response;
            }
            catch (Exception e) {
                boolean judgeRetry = this.judgeRetry(retryRules, e);
                if (!judgeRetry) {
                    throw e;
                }
                try {
                    logger.debug("The response fails, retry is performed\uff01The cause is " + e.getMessage());
                    if (--maxRetries < 0) {
                        throw e;
                    }
                    Thread.sleep(intervalMs);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    private boolean judgeRetry(RetryRule[] retryRules, Exception e) {
        if (this.containRetryRule(retryRules, RetryRule.OCCUR_EXCEPTION)) {
            return true;
        }
        if (this.containRetryRule(retryRules, RetryRule.OCCUR_IO_EXCEPTION)) {
            return e instanceof IOException;
        }
        return false;
    }

    private boolean containRetryRule(RetryRule[] retryRules, RetryRule retryRule) {
        for (RetryRule rule : retryRules) {
            if (!rule.equals((Object)retryRule)) continue;
            return true;
        }
        return false;
    }
}

